/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.web.ErrorResponseException;

public interface ErrorResponse {
    public HttpStatusCode getStatusCode();

    default public HttpHeaders getHeaders() {
        return HttpHeaders.EMPTY;
    }

    public ProblemDetail getBody();

    default public String getDetailMessageCode() {
        return ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
    }

    @Nullable
    default public Object[] getDetailMessageArguments() {
        return null;
    }

    @Nullable
    default public Object[] getDetailMessageArguments(MessageSource messageSource, Locale locale) {
        return this.getDetailMessageArguments();
    }

    default public String getTitleMessageCode() {
        return ErrorResponse.getDefaultTitleMessageCode(this.getClass());
    }

    default public ProblemDetail updateAndGetBody(@Nullable MessageSource messageSource, Locale locale) {
        if (messageSource != null) {
            String title;
            Object[] arguments = this.getDetailMessageArguments(messageSource, locale);
            String detail = messageSource.getMessage(this.getDetailMessageCode(), arguments, null, locale);
            if (detail != null) {
                this.getBody().setDetail(detail);
            }
            if ((title = messageSource.getMessage(this.getTitleMessageCode(), null, null, locale)) != null) {
                this.getBody().setTitle(title);
            }
        }
        return this.getBody();
    }

    public static String getDefaultDetailMessageCode(Class<?> exceptionType, @Nullable String suffix) {
        return "problemDetail." + exceptionType.getName() + (String)(suffix != null ? "." + suffix : "");
    }

    public static String getDefaultTitleMessageCode(Class<?> exceptionType) {
        return "problemDetail.title." + exceptionType.getName();
    }

    public static ErrorResponse createFor(Exception ex, HttpStatusCode status, @Nullable HttpHeaders headers, String defaultDetail, @Nullable String detailMessageCode, @Nullable Object[] detailMessageArguments) {
        if (detailMessageCode == null) {
            detailMessageCode = ErrorResponse.getDefaultDetailMessageCode(ex.getClass(), null);
        }
        ErrorResponseException errorResponse = new ErrorResponseException(status, ProblemDetail.forStatusAndDetail(status, defaultDetail), null, detailMessageCode, detailMessageArguments);
        if (headers != null) {
            errorResponse.getHeaders().putAll((Map<? extends String, ? extends List<String>>)((Object)headers));
        }
        return errorResponse;
    }
}

