/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import jakarta.servlet.ServletException;
import java.util.Collections;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.web.ErrorResponse;

public abstract class HttpMediaTypeException
extends ServletException
implements ErrorResponse {
    private final List<MediaType> supportedMediaTypes;
    private final ProblemDetail body = ProblemDetail.forStatus(this.getStatusCode());

    protected HttpMediaTypeException(String message) {
        super(message);
        this.supportedMediaTypes = Collections.emptyList();
    }

    protected HttpMediaTypeException(String message, List<MediaType> supportedMediaTypes) {
        super(message);
        this.supportedMediaTypes = Collections.unmodifiableList(supportedMediaTypes);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }
}

