/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.multipart.MultipartWriterSupport;
import org.springframework.http.codec.multipart.PartEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartEventHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<PartEvent> {
    public PartEventHttpMessageWriter() {
        super(Collections.singletonList(MediaType.MULTIPART_FORM_DATA));
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (PartEvent.class.isAssignableFrom(elementType.toClass())) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : this.getWritableMediaTypes()) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends PartEvent> partDataStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(Hints.getLogPrefix(hints) + "Encoding Publisher<PartEvent>"));
        }
        Flux body = Flux.from(partDataStream).windowUntil(PartEvent::isLast).concatMap(partData -> partData.switchOnFirst((signal, flux) -> {
            if (signal.hasValue()) {
                PartEvent value = (PartEvent)signal.get();
                Assert.state((value != null ? 1 : 0) != 0, (String)"Null value");
                return this.encodePartData(boundary, outputMessage.bufferFactory(), value, (Flux<? extends PartEvent>)flux);
            }
            return flux.cast(DataBuffer.class);
        })).concatWith(this.generateLastLine(boundary, outputMessage.bufferFactory())).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body = body.doOnNext(buffer -> Hints.touchDataBuffer((DataBuffer)buffer, (Map)hints, (Log)this.logger));
        }
        return outputMessage.writeWith((Publisher<? extends DataBuffer>)body);
    }

    private Flux<DataBuffer> encodePartData(byte[] boundary, DataBufferFactory bufferFactory, PartEvent first, Flux<? extends PartEvent> flux) {
        return Flux.concat((Publisher[])new Publisher[]{this.generateBoundaryLine(boundary, bufferFactory), this.generatePartHeaders(first.headers(), bufferFactory), flux.map(PartEvent::content), this.generateNewLine(bufferFactory)});
    }
}

