/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.CookieValueArgumentResolver;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpMethodArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceMethod;
import org.springframework.web.service.invoker.PathVariableArgumentResolver;
import org.springframework.web.service.invoker.RequestBodyArgumentResolver;
import org.springframework.web.service.invoker.RequestHeaderArgumentResolver;
import org.springframework.web.service.invoker.RequestParamArgumentResolver;
import org.springframework.web.service.invoker.UrlArgumentResolver;

public final class HttpServiceProxyFactory {
    private final HttpClientAdapter clientAdapter;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final Duration blockTimeout;

    private HttpServiceProxyFactory(HttpClientAdapter clientAdapter, List<HttpServiceArgumentResolver> argumentResolvers, ReactiveAdapterRegistry reactiveAdapterRegistry, Duration blockTimeout) {
        this.clientAdapter = clientAdapter;
        this.argumentResolvers = argumentResolvers;
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        this.blockTimeout = blockTimeout;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<HttpServiceMethod> methods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> new HttpServiceMethod((Method)method, serviceType, this.argumentResolvers, this.clientAdapter, this.reactiveAdapterRegistry, this.blockTimeout)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new HttpServiceMethodInterceptor(methods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, HttpExchange.class);
    }

    public static Builder builder(HttpClientAdapter adapter) {
        return new Builder(adapter);
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, HttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<HttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(HttpServiceMethod::getMethod, Function.identity()));
        }

        public Object invoke(MethodInvocation invocation) {
            Method method = invocation.getMethod();
            HttpServiceMethod httpServiceMethod = this.httpServiceMethods.get(method);
            return httpServiceMethod.invoke(invocation.getArguments());
        }
    }

    public static final class Builder {
        private final HttpClientAdapter clientAdapter;
        private final List<HttpServiceArgumentResolver> customResolvers = new ArrayList<HttpServiceArgumentResolver>();
        @Nullable
        private ConversionService conversionService;
        private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
        private Duration blockTimeout = Duration.ofSeconds(5L);

        private Builder(HttpClientAdapter clientAdapter) {
            Assert.notNull((Object)clientAdapter, (String)"HttpClientAdapter is required");
            this.clientAdapter = clientAdapter;
        }

        public Builder addCustomResolver(HttpServiceArgumentResolver resolver) {
            this.customResolvers.add(resolver);
            return this;
        }

        public Builder setConversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
            this.reactiveAdapterRegistry = registry;
            return this;
        }

        public Builder setBlockTimeout(Duration blockTimeout) {
            this.blockTimeout = blockTimeout;
            return this;
        }

        public HttpServiceProxyFactory build() {
            ConversionService conversionService = this.initConversionService();
            List<HttpServiceArgumentResolver> resolvers = this.initArgumentResolvers(conversionService);
            return new HttpServiceProxyFactory(this.clientAdapter, resolvers, this.reactiveAdapterRegistry, this.blockTimeout);
        }

        private ConversionService initConversionService() {
            return this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
        }

        private List<HttpServiceArgumentResolver> initArgumentResolvers(ConversionService conversionService) {
            ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>(this.customResolvers);
            resolvers.add(new RequestHeaderArgumentResolver(conversionService));
            resolvers.add(new RequestBodyArgumentResolver(this.reactiveAdapterRegistry));
            resolvers.add(new PathVariableArgumentResolver(conversionService));
            resolvers.add(new RequestParamArgumentResolver(conversionService));
            resolvers.add(new CookieValueArgumentResolver(conversionService));
            resolvers.add(new UrlArgumentResolver());
            resolvers.add(new HttpMethodArgumentResolver());
            return resolvers;
        }
    }
}

