/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;

public class HttpMethodArgumentResolver
implements HttpServiceArgumentResolver {
    private static final Log logger = LogFactory.getLog(HttpMethodArgumentResolver.class);

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        if (!parameter.getParameterType().equals(HttpMethod.class)) {
            return false;
        }
        if (argument != null) {
            HttpMethod httpMethod = (HttpMethod)argument;
            requestValues.setHttpMethod(httpMethod);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Resolved HTTP method to: " + httpMethod.name()));
            }
        }
        return true;
    }
}

