/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;

public abstract class AbstractNamedValueArgumentResolver
implements HttpServiceArgumentResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConversionService conversionService;
    private final Map<MethodParameter, NamedValueInfo> namedValueInfoCache = new ConcurrentHashMap<MethodParameter, NamedValueInfo>(256);

    protected AbstractNamedValueArgumentResolver(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService is required");
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        NamedValueInfo info = this.getNamedValueInfo(parameter);
        if (info == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(parameter.getParameterType())) {
            Assert.isInstanceOf(Map.class, (Object)argument);
            for (Map.Entry entry : ((Map)argument).entrySet()) {
                this.addSingleOrMultipleValues((String)entry.getKey(), entry.getValue(), false, null, info.label, info.multiValued, requestValues);
            }
        } else {
            this.addSingleOrMultipleValues(info.name, argument, info.required, info.defaultValue, info.label, info.multiValued, requestValues);
        }
        return true;
    }

    @Nullable
    private NamedValueInfo getNamedValueInfo(MethodParameter parameter) {
        NamedValueInfo info = this.namedValueInfoCache.get(parameter);
        if (info == null) {
            info = this.createNamedValueInfo(parameter);
            if (info == null) {
                return null;
            }
            info = this.updateNamedValueInfo(parameter, info);
            this.namedValueInfoCache.put(parameter, info);
        }
        return info;
    }

    @Nullable
    protected abstract NamedValueInfo createNamedValueInfo(MethodParameter var1);

    private NamedValueInfo updateNamedValueInfo(MethodParameter parameter, NamedValueInfo info) {
        String name = info.name;
        if (info.name.isEmpty() && (name = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument of type [" + parameter.getParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
        }
        boolean required = info.required && !parameter.getParameterType().equals(Optional.class);
        String defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(info.defaultValue) ? null : info.defaultValue;
        return info.update(name, required, defaultValue);
    }

    private void addSingleOrMultipleValues(String name, @Nullable Object value, boolean required, @Nullable Object defaultValue, String valueLabel, boolean supportsMultiValues, HttpRequestValues.Builder requestValues) {
        if (supportsMultiValues) {
            List<Object> list = value = ObjectUtils.isArray((Object)value) ? Arrays.asList((Object[])value) : value;
            if (value instanceof Collection) {
                Collection elements = value;
                boolean hasValues = false;
                for (Object element : elements) {
                    if (element == null) continue;
                    hasValues = true;
                    this.addSingleValue(name, element, false, null, valueLabel, requestValues);
                }
                if (hasValues) {
                    return;
                }
                value = null;
            }
        }
        this.addSingleValue(name, value, required, defaultValue, valueLabel, requestValues);
    }

    private void addSingleValue(String name, @Nullable Object value, boolean required, @Nullable Object defaultValue, String valueLabel, HttpRequestValues.Builder requestValues) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            value = optionalValue.orElse(null);
        }
        if (value == null && defaultValue != null) {
            value = defaultValue;
        }
        if (!(value instanceof String)) {
            value = this.getConversionService().convert(value, String.class);
        }
        if (value == null) {
            Assert.isTrue((!required ? 1 : 0) != 0, (String)("Missing " + valueLabel + " value '" + name + "'"));
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Resolved " + valueLabel + " value '" + name + ":" + value + "'"));
        }
        this.addRequestValue(name, (String)value, requestValues);
    }

    protected abstract void addRequestValue(String var1, String var2, HttpRequestValues.Builder var3);

    protected static class NamedValueInfo {
        private final String name;
        private final boolean required;
        @Nullable
        private final String defaultValue;
        private final String label;
        private final boolean multiValued;

        public NamedValueInfo(String name, boolean required, @Nullable String defaultValue, String label, boolean multiValued) {
            this.name = name;
            this.required = required;
            this.defaultValue = defaultValue;
            this.label = label;
            this.multiValued = multiValued;
        }

        public NamedValueInfo update(String name, boolean required, @Nullable String defaultValue) {
            return new NamedValueInfo(name, required, defaultValue, this.label, this.multiValued);
        }
    }
}

