/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server;

import org.springframework.core.NestedExceptionUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.web.ErrorResponseException;

public class ResponseStatusException
extends ErrorResponseException {
    @Nullable
    private final String reason;

    public ResponseStatusException(HttpStatusCode status) {
        this(status, (String)null);
    }

    public ResponseStatusException(HttpStatusCode status, @Nullable String reason) {
        this(status, reason, null);
    }

    public ResponseStatusException(int rawStatusCode, @Nullable String reason, @Nullable Throwable cause) {
        this(HttpStatusCode.valueOf(rawStatusCode), reason, cause);
    }

    public ResponseStatusException(HttpStatusCode status, @Nullable String reason, @Nullable Throwable cause) {
        super(status, cause);
        this.reason = reason;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.getResponseHeaders();
    }

    @Deprecated
    public HttpHeaders getResponseHeaders() {
        return HttpHeaders.EMPTY;
    }

    @Override
    public String getMessage() {
        String msg = this.getStatusCode() + (String)(this.reason != null ? " \"" + this.reason + "\"" : "");
        return NestedExceptionUtils.buildMessage((String)msg, (Throwable)this.getCause());
    }
}

