/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.JettyHeadersAdapter;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class JettyHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public JettyHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpRequest createRequest(HttpServletRequest request, AsyncContext context) throws IOException, URISyntaxException {
        Assert.notNull((Object)this.getServletPath(), (String)"Servlet path is not initialized");
        return new JettyServerHttpRequest(request, context, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    @Override
    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context, ServletServerHttpRequest request) throws IOException {
        return new JettyServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class JettyServerHttpRequest
    extends ServletServerHttpRequest {
        JettyServerHttpRequest(HttpServletRequest request, AsyncContext asyncContext, String servletPath, DataBufferFactory bufferFactory, int bufferSize) throws IOException, URISyntaxException {
            super(JettyServerHttpRequest.createHeaders(request), request, asyncContext, servletPath, bufferFactory, bufferSize);
        }

        private static MultiValueMap<String, String> createHeaders(HttpServletRequest servletRequest) {
            Request request = JettyServerHttpRequest.getRequest(servletRequest);
            HttpFields.Mutable fields = HttpFields.build((HttpFields)request.getHttpFields());
            return new JettyHeadersAdapter(fields);
        }

        private static Request getRequest(HttpServletRequest request) {
            if (request instanceof Request) {
                Request jettyRequest = (Request)request;
                return jettyRequest;
            }
            if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
                return JettyServerHttpRequest.getRequest(wrappedRequest);
            }
            throw new IllegalArgumentException("Cannot convert [" + request.getClass() + "] to org.eclipse.jetty.server.Request");
        }
    }

    private static final class JettyServerHttpResponse
    extends ServletServerHttpResponse {
        JettyServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(JettyServerHttpResponse.createHeaders(response), response, asyncContext, bufferFactory, bufferSize, request);
        }

        private static HttpHeaders createHeaders(HttpServletResponse servletResponse) {
            Response response = JettyServerHttpResponse.getResponse(servletResponse);
            HttpFields.Mutable fields = response.getHttpFields();
            return new HttpHeaders(new JettyHeadersAdapter(fields));
        }

        private static Response getResponse(HttpServletResponse response) {
            if (response instanceof Response) {
                Response jettyResponse = (Response)response;
                return jettyResponse;
            }
            if (response instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
                HttpServletResponse wrappedResponse = (HttpServletResponse)wrapper.getResponse();
                return JettyServerHttpResponse.getResponse(wrappedResponse);
            }
            throw new IllegalArgumentException("Cannot convert [" + response.getClass() + "] to org.eclipse.jetty.server.Response");
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ByteBuffer input = dataBuffer.asByteBuffer();
            int len = input.remaining();
            ServletResponse response = (ServletResponse)this.getNativeResponse();
            ((HttpOutput)response.getOutputStream()).write(input);
            return len;
        }

        @Override
        protected void applyHeaders() {
            long contentLength;
            Charset charset;
            HttpServletResponse response = (HttpServletResponse)this.getNativeResponse();
            MediaType contentType = null;
            try {
                contentType = this.getHeaders().getContentType();
            }
            catch (Exception ex) {
                String rawContentType = this.getHeaders().getFirst("Content-Type");
                response.setContentType(rawContentType);
            }
            if (response.getContentType() == null && contentType != null) {
                response.setContentType(contentType.toString());
            }
            Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
            if (response.getCharacterEncoding() == null && charset != null) {
                response.setCharacterEncoding(charset.name());
            }
            if ((contentLength = this.getHeaders().getContentLength()) != -1L) {
                response.setContentLengthLong(contentLength);
            }
        }
    }
}

