/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jetty.util.component.LifeCycle;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class JdkHttpClientResourceFactory
implements InitializingBean,
DisposableBean {
    @Nullable
    private Executor executor;
    private String threadPrefix = "jdk-http";

    public void setExecutor(@Nullable Executor executor) {
        this.executor = executor;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    public void setThreadPrefix(String threadPrefix) {
        Assert.notNull((Object)threadPrefix, (String)"Thread prefix is required");
        this.threadPrefix = threadPrefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.executor == null) {
            String name = this.threadPrefix + "@" + Integer.toHexString(this.hashCode());
            this.executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory(name));
        }
        if (this.executor instanceof LifeCycle) {
            ((LifeCycle)this.executor).start();
        }
    }

    public void destroy() throws Exception {
        try {
            if (this.executor instanceof LifeCycle) {
                ((LifeCycle)this.executor).stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

