/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.net.URI;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ProblemDetail {
    private static final URI BLANK_TYPE = URI.create("about:blank");
    private URI type = BLANK_TYPE;
    @Nullable
    private String title;
    private int status;
    @Nullable
    private String detail;
    @Nullable
    private URI instance;

    protected ProblemDetail(int rawStatusCode) {
        this.status = rawStatusCode;
    }

    protected ProblemDetail(ProblemDetail other) {
        this.type = other.type;
        this.title = other.title;
        this.status = other.status;
        this.detail = other.detail;
        this.instance = other.instance;
    }

    protected ProblemDetail() {
    }

    public ProblemDetail withType(URI type) {
        this.setType(type);
        return this;
    }

    public ProblemDetail withTitle(@Nullable String title) {
        this.setTitle(title);
        return this;
    }

    public ProblemDetail withStatus(HttpStatusCode statusCode) {
        Assert.notNull((Object)statusCode, (String)"HttpStatus is required");
        this.setStatus(statusCode.value());
        return this;
    }

    public ProblemDetail withStatus(int status) {
        this.setStatus(status);
        return this;
    }

    public ProblemDetail withDetail(@Nullable String detail) {
        this.setDetail(detail);
        return this;
    }

    public ProblemDetail withInstance(@Nullable URI instance) {
        this.setInstance(instance);
        return this;
    }

    public void setType(URI type) {
        Assert.notNull((Object)type, (String)"'type' is required");
        this.type = type;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setDetail(@Nullable String detail) {
        this.detail = detail;
    }

    public void setInstance(@Nullable URI instance) {
        this.instance = instance;
    }

    public URI getType() {
        return this.type;
    }

    @Nullable
    public String getTitle() {
        HttpStatus httpStatus;
        if (this.title == null && (httpStatus = HttpStatus.resolve(this.status)) != null) {
            return httpStatus.getReasonPhrase();
        }
        return this.title;
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    @Nullable
    public URI getInstance() {
        return this.instance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.initToStringContent() + "]";
    }

    protected String initToStringContent() {
        return "type='" + this.type + "', title='" + this.getTitle() + "', status=" + this.getStatus() + ", detail='" + this.getDetail() + "', instance='" + this.getInstance() + "'";
    }

    public static ProblemDetail forStatus(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        return ProblemDetail.forStatus(status.value());
    }

    public static ProblemDetail forStatus(int status) {
        return new ProblemDetail(status);
    }
}

