/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.http.HttpLogging;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;

public abstract class Jackson2CodecSupport {
    public static final String JSON_VIEW_HINT = Jackson2CodecSupport.class.getName() + ".jsonView";
    private static final String JSON_VIEW_HINT_ERROR = "@JsonView only supported for write hints with exactly 1 class argument: ";
    private static final List<MimeType> DEFAULT_MIME_TYPES = Collections.unmodifiableList(Arrays.asList(new MimeType("application", "json", StandardCharsets.UTF_8), new MimeType("application", "*+json", StandardCharsets.UTF_8)));
    private static final Map<String, JsonEncoding> ENCODINGS = Jackson2CodecSupport.jsonEncodings();
    protected final Log logger = HttpLogging.forLogName(this.getClass());
    private final ObjectMapper objectMapper;
    private final List<MimeType> mimeTypes;

    protected Jackson2CodecSupport(ObjectMapper objectMapper, MimeType ... mimeTypes) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
        this.mimeTypes = !ObjectUtils.isEmpty((Object[])mimeTypes) ? Collections.unmodifiableList(Arrays.asList(mimeTypes)) : DEFAULT_MIME_TYPES;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected List<MimeType> getMimeTypes() {
        return this.mimeTypes;
    }

    protected boolean supportsMimeType(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        if (this.mimeTypes.stream().noneMatch(m -> m.isCompatibleWith(mimeType))) {
            return false;
        }
        if (mimeType.getCharset() != null) {
            Charset charset = mimeType.getCharset();
            return ENCODINGS.containsKey(charset.name());
        }
        return true;
    }

    protected JavaType getJavaType(Type type, @Nullable Class<?> contextClass) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        return typeFactory.constructType(GenericTypeResolver.resolveType((Type)type, contextClass));
    }

    protected Map<String, Object> getHints(ResolvableType resolvableType) {
        JsonView annotation;
        MethodParameter param = this.getParameter(resolvableType);
        if (param != null && (annotation = this.getAnnotation(param, JsonView.class)) != null) {
            Class[] classes = annotation.value();
            Assert.isTrue((classes.length == 1 ? 1 : 0) != 0, (String)(JSON_VIEW_HINT_ERROR + param));
            return Hints.from((String)JSON_VIEW_HINT, (Object)classes[0]);
        }
        return Hints.none();
    }

    @Nullable
    protected MethodParameter getParameter(ResolvableType type) {
        return type.getSource() instanceof MethodParameter ? (MethodParameter)type.getSource() : null;
    }

    @Nullable
    protected abstract <A extends Annotation> A getAnnotation(MethodParameter var1, Class<A> var2);

    private static Map<String, JsonEncoding> jsonEncodings() {
        return EnumSet.allOf(JsonEncoding.class).stream().collect(Collectors.toMap(JsonEncoding::getJavaName, Function.identity()));
    }
}

