/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class ServletServerHttpRequest
extends AbstractServerHttpRequest {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final HttpServletRequest request;
    private final RequestBodyPublisher bodyPublisher;
    private final Object cookieLock = new Object();
    private final DataBufferFactory bufferFactory;
    private final byte[] buffer;

    public ServletServerHttpRequest(HttpServletRequest request, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize) throws IOException {
        super(ServletServerHttpRequest.initUri(request), request.getContextPath(), ServletServerHttpRequest.initHeaders(request));
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0, (String)"'bufferSize' must be higher than 0");
        this.request = request;
        this.bufferFactory = bufferFactory;
        this.buffer = new byte[bufferSize];
        asyncContext.addListener((AsyncListener)new RequestAsyncListener());
        ServletInputStream inputStream = request.getInputStream();
        this.bodyPublisher = new RequestBodyPublisher(inputStream);
        this.bodyPublisher.registerReadListener();
    }

    private static URI initUri(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        try {
            StringBuffer url = request.getRequestURL();
            String query = request.getQueryString();
            if (StringUtils.hasText((String)query)) {
                url.append('?').append(query);
            }
            return new URI(url.toString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get URI: " + ex.getMessage(), ex);
        }
    }

    private static HttpHeaders initHeaders(HttpServletRequest request) {
        int contentLength;
        String encoding;
        String requestContentType;
        HttpHeaders headers = new HttpHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.add(name, (String)values.nextElement());
            }
        }
        MediaType contentType = headers.getContentType();
        if (contentType == null && StringUtils.hasLength((String)(requestContentType = request.getContentType()))) {
            contentType = MediaType.parseMediaType(requestContentType);
            headers.setContentType(contentType);
        }
        if (contentType != null && contentType.getCharset() == null && StringUtils.hasLength((String)(encoding = request.getCharacterEncoding()))) {
            Charset charset = Charset.forName(encoding);
            LinkedCaseInsensitiveMap params = new LinkedCaseInsensitiveMap();
            params.putAll(contentType.getParameters());
            params.put("charset", charset.toString());
            headers.setContentType(new MediaType(contentType.getType(), contentType.getSubtype(), (Map<String, String>)params));
        }
        if (headers.getContentLength() == -1L && (contentLength = request.getContentLength()) != -1) {
            headers.setContentLength(contentLength);
        }
        return headers;
    }

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    @Override
    public String getMethodValue() {
        return this.getServletRequest().getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap httpCookies = new LinkedMultiValueMap();
        Cookie[] cookieArray = this.cookieLock;
        synchronized (this.cookieLock) {
            Cookie[] cookies = this.request.getCookies();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    HttpCookie httpCookie = new HttpCookie(name, cookie.getValue());
                    httpCookies.add((Object)name, (Object)httpCookie);
                }
            }
            return httpCookies;
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.request.getRemoteHost(), this.request.getRemotePort());
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)this.bodyPublisher);
    }

    @Nullable
    protected DataBuffer readFromInputStream() throws IOException {
        int read = this.request.getInputStream().read(this.buffer);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("read:" + read));
        }
        if (read > 0) {
            DataBuffer dataBuffer = this.bufferFactory.allocateBuffer(read);
            dataBuffer.write(this.buffer, 0, read);
            return dataBuffer;
        }
        return null;
    }

    private class RequestBodyPublisher
    extends AbstractListenerReadPublisher<DataBuffer> {
        private final ServletInputStream inputStream;

        public RequestBodyPublisher(ServletInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void registerReadListener() throws IOException {
            this.inputStream.setReadListener((ReadListener)new RequestBodyPublisherReadListener());
        }

        @Override
        protected void checkOnDataAvailable() {
            if (!this.inputStream.isFinished() && this.inputStream.isReady()) {
                this.onDataAvailable();
            }
        }

        @Override
        @Nullable
        protected DataBuffer read() throws IOException {
            if (this.inputStream.isReady()) {
                return ServletServerHttpRequest.this.readFromInputStream();
            }
            return null;
        }

        private class RequestBodyPublisherReadListener
        implements ReadListener {
            private RequestBodyPublisherReadListener() {
            }

            public void onDataAvailable() throws IOException {
                RequestBodyPublisher.this.onDataAvailable();
            }

            public void onAllDataRead() throws IOException {
                RequestBodyPublisher.this.onAllDataRead();
            }

            public void onError(Throwable throwable) {
                RequestBodyPublisher.this.onError(throwable);
            }
        }
    }

    private final class RequestAsyncListener
    implements AsyncListener {
        private RequestAsyncListener() {
        }

        public void onStartAsync(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
            Throwable ex = event.getThrowable();
            ex = ex != null ? ex : new IllegalStateException("Async operation timeout.");
            ServletServerHttpRequest.this.bodyPublisher.onError(ex);
        }

        public void onError(AsyncEvent event) {
            ServletServerHttpRequest.this.bodyPublisher.onError(event.getThrowable());
        }

        public void onComplete(AsyncEvent event) {
            ServletServerHttpRequest.this.bodyPublisher.onAllDataRead();
        }
    }
}

