/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.http.server.HttpServerRequest;

public class ReactorServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerRequest request;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorServerHttpRequest(HttpServerRequest request, NettyDataBufferFactory bufferFactory) throws URISyntaxException {
        super(ReactorServerHttpRequest.initUri(request), "", ReactorServerHttpRequest.initHeaders(request));
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        this.request = request;
        this.bufferFactory = bufferFactory;
    }

    private static URI initUri(HttpServerRequest request) throws URISyntaxException {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        return new URI(ReactorServerHttpRequest.resolveBaseUrl(request).toString() + request.uri());
    }

    private static URI resolveBaseUrl(HttpServerRequest request) throws URISyntaxException {
        String scheme = ReactorServerHttpRequest.getScheme(request);
        String header = request.requestHeaders().get((CharSequence)HttpHeaderNames.HOST);
        if (header != null) {
            int portIndex = header.startsWith("[") ? header.indexOf(58, header.indexOf(93)) : header.indexOf(58);
            if (portIndex != -1) {
                try {
                    return new URI(scheme, null, header.substring(0, portIndex), Integer.parseInt(header.substring(portIndex + 1)), null, null, null);
                }
                catch (NumberFormatException ex) {
                    throw new URISyntaxException(header, "Unable to parse port", portIndex);
                }
            }
            return new URI(scheme, header, null, null);
        }
        InetSocketAddress localAddress = (InetSocketAddress)request.context().channel().localAddress();
        return new URI(scheme, null, localAddress.getHostString(), localAddress.getPort(), null, null, null);
    }

    private static String getScheme(HttpServerRequest request) {
        ChannelPipeline pipeline = request.context().channel().pipeline();
        boolean ssl = pipeline.get(SslHandler.class) != null;
        return ssl ? "https" : "http";
    }

    private static HttpHeaders initHeaders(HttpServerRequest channel) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : channel.requestHeaders().names()) {
            headers.put(name, channel.requestHeaders().getAll(name));
        }
        return headers;
    }

    public HttpServerRequest getReactorRequest() {
        return this.request;
    }

    @Override
    public String getMethodValue() {
        return this.request.method().name();
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (CharSequence name : this.request.cookies().keySet()) {
            for (Cookie cookie : (Set)this.request.cookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookie.value());
                cookies.add((Object)name.toString(), (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.request.remoteAddress();
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.request.receive().retain().map(arg_0 -> ((NettyDataBufferFactory)this.bufferFactory).wrap(arg_0));
    }
}

