/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class StandardServletMultipartResolver
implements MultipartResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        return new StandardMultipartHttpServletRequest(request);
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        try {
            for (Part part : request.getParts()) {
                part.delete();
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Failed to perform cleanup of multipart items", (Throwable)ex);
        }
    }

    private static class StandardMultipartFile
    implements MultipartFile {
        private final Part part;

        public StandardMultipartFile(Part part) {
            this.part = part;
        }

        public String getName() {
            return this.part.getName();
        }

        public String getOriginalFilename() {
            return null;
        }

        public String getContentType() {
            return this.part.getContentType();
        }

        public boolean isEmpty() {
            return this.part.getSize() == 0L;
        }

        public long getSize() {
            return this.part.getSize();
        }

        public byte[] getBytes() throws IOException {
            return FileCopyUtils.copyToByteArray((InputStream)this.part.getInputStream());
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            this.part.write(dest.getPath());
        }
    }

    private static class StandardMultipartHttpServletRequest
    extends AbstractMultipartHttpServletRequest {
        public StandardMultipartHttpServletRequest(HttpServletRequest request) throws MultipartException {
            super(request);
            try {
                Collection parts = request.getParts();
                LinkedMultiValueMap files = new LinkedMultiValueMap(parts.size());
                for (Part part : parts) {
                    files.add((Object)part.getName(), (Object)new StandardMultipartFile(part));
                }
                this.setMultipartFiles((MultiValueMap<String, MultipartFile>)files);
            }
            catch (Exception ex) {
                throw new MultipartException("Could not parse multipart servlet request", ex);
            }
        }
    }
}

