/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.util.Map;
import org.springframework.ui.ModelMap;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.support.BindingAwareModelMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAndViewContainer {
    private String viewName;
    private Object view;
    private final ModelMap model;
    private boolean resolveView = true;

    public ModelAndViewContainer() {
        this.model = new BindingAwareModelMap();
    }

    public ModelAndViewContainer(ModelMap model) {
        Assert.notNull((Object)model);
        this.model = model;
    }

    public ModelMap getModel() {
        return this.model;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public Object getView() {
        return this.view;
    }

    public void setView(Object view) {
        this.view = view;
    }

    public boolean isResolveView() {
        return this.resolveView;
    }

    public void setResolveView(boolean resolveView) {
        this.resolveView = resolveView;
    }

    public boolean containsAttribute(String name) {
        return StringUtils.hasText((String)name) && this.model.containsAttribute(name);
    }

    public Object getAttribute(String name) {
        return this.model.get((Object)name);
    }

    public void addAttribute(String name, Object value) {
        this.model.addAttribute(name, value);
    }

    public void addAllAttributes(Map<String, ?> attributes) {
        this.model.addAllAttributes(attributes);
    }

    public void mergeAttribute(String name, Object value) {
        if (!this.containsAttribute(name)) {
            this.model.addAttribute(name, value);
        }
    }
}

