/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocableHandlerMethod
extends HandlerMethod {
    private HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private WebDataBinderFactory dataBinderFactory;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public InvocableHandlerMethod(Object bean, Method method) {
        super(bean, method);
    }

    public InvocableHandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean, methodName, parameterTypes);
    }

    public void setDataBinderFactory(WebDataBinderFactory dataBinderFactory) {
        this.dataBinderFactory = dataBinderFactory;
    }

    public void setHandlerMethodArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public final Object invokeForRequest(NativeWebRequest request, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object[] args = this.getMethodArgumentValues(request, mavContainer, providedArgs);
        if (this.logger.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder("Invoking [");
            builder.append(this.getMethod().getName()).append("] method with arguments ");
            builder.append(Arrays.asList(args));
            this.logger.trace((Object)builder.toString());
        }
        Object returnValue = this.invoke(args);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Method [" + this.getMethod().getName() + "] returned [" + returnValue + "]"));
        }
        return returnValue;
    }

    private Object[] getMethodArgumentValues(NativeWebRequest request, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        MethodParameter[] parameters = this.getMethodParameters();
        Object[] args = new Object[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            MethodParameter parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.getBean().getClass());
            args[i] = this.resolveProvidedArgument(parameter, providedArgs);
            if (args[i] == null) {
                if (this.argumentResolvers.supportsParameter(parameter)) {
                    args[i] = this.argumentResolvers.resolveArgument(parameter, mavContainer, request, this.dataBinderFactory);
                } else {
                    throw new IllegalStateException("Cannot resolve argument index=" + parameter.getParameterIndex() + ", name=" + parameter.getParameterName() + ", type=" + parameter.getParameterType() + " in method " + this.toString());
                }
            }
            ++i;
        }
        return args;
    }

    private Object resolveProvidedArgument(MethodParameter parameter, Object ... providedArgs) {
        if (providedArgs == null) {
            return null;
        }
        Object[] objectArray = providedArgs;
        int n = providedArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object providedArg = objectArray[n2];
            if (parameter.getParameterType().isInstance(providedArg)) {
                return providedArg;
            }
            ++n2;
        }
        return null;
    }

    private Object invoke(Object ... args) throws Exception {
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        try {
            return this.getBridgedMethod().invoke(this.getBean(), args);
        }
        catch (IllegalArgumentException ex) {
            this.handleIllegalArgumentException(ex, args);
            throw ex;
        }
        catch (InvocationTargetException ex) {
            this.handleInvocationTargetException(ex);
            throw new IllegalStateException("Unexpected exception thrown by method - " + ex.getTargetException().getClass().getName() + ": " + ex.getTargetException().getMessage());
        }
    }

    private void handleIllegalArgumentException(IllegalArgumentException ex, Object ... args) {
        StringBuilder builder = new StringBuilder(ex.getMessage());
        builder.append(" :: method=").append(this.getBridgedMethod().toGenericString());
        builder.append(" :: invoked with handler type=").append(this.getBeanType().getName());
        if (args != null && args.length > 0) {
            builder.append(" and argument types ");
            int i = 0;
            while (i < args.length) {
                String argClass = args[i] != null ? args[i].getClass().toString() : "null";
                builder.append(" : arg[").append(i).append("] ").append(argClass);
                ++i;
            }
        } else {
            builder.append(" and 0 arguments");
        }
        throw new IllegalArgumentException(builder.toString(), ex);
    }

    private void handleInvocationTargetException(InvocationTargetException ex) throws Exception {
        Throwable targetException = ex.getTargetException();
        if (targetException instanceof RuntimeException) {
            throw (RuntimeException)targetException;
        }
        if (targetException instanceof Error) {
            throw (Error)targetException;
        }
        if (targetException instanceof Exception) {
            throw (Exception)targetException;
        }
    }
}

