/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodReturnValueHandlerComposite
implements HandlerMethodReturnValueHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
    private final Map<MethodParameter, HandlerMethodReturnValueHandler> returnValueHandlerCache = new ConcurrentHashMap<MethodParameter, HandlerMethodReturnValueHandler>();

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getReturnValueHandler(returnType) != null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        if (handler == null) {
            throw new IllegalStateException("No suitable HandlerMethodReturnValueHandler found. supportsReturnType(MethodParameter) should have been called previously");
        }
        handler.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    private HandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType) {
        HandlerMethodReturnValueHandler result = this.returnValueHandlerCache.get(returnType);
        if (result == null) {
            for (HandlerMethodReturnValueHandler returnValueHandler : this.returnValueHandlers) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Testing if return value handler [" + returnValueHandler + "] supports [" + returnType.getGenericParameterType() + "]"));
                }
                if (!returnValueHandler.supportsReturnType(returnType)) continue;
                result = returnValueHandler;
                this.returnValueHandlerCache.put(returnType, returnValueHandler);
                break;
            }
        }
        return result;
    }

    public void addHandler(HandlerMethodReturnValueHandler returnValuehandler) {
        this.returnValueHandlers.add(returnValuehandler);
    }

    public void addHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        if (returnValueHandlers != null) {
            for (HandlerMethodReturnValueHandler handler : returnValueHandlers) {
                this.returnValueHandlers.add(handler);
            }
        }
    }
}

