/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation.support;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ModelMethodProcessor
implements HandlerMethodArgumentResolver,
HandlerMethodReturnValueHandler {
    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return Model.class.isAssignableFrom(paramType) || Map.class.isAssignableFrom(paramType);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return mavContainer.getModel();
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        boolean hasModelAttr;
        Class paramType = returnType.getParameterType();
        boolean bl = hasModelAttr = returnType.getMethodAnnotation(ModelAttribute.class) != null;
        return Model.class.isAssignableFrom(paramType) || Map.class.isAssignableFrom(paramType) && !hasModelAttr;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            return;
        }
        if (returnValue instanceof Model) {
            mavContainer.addAllAttributes(((Model)returnValue).asMap());
        } else if (returnValue instanceof Map) {
            mavContainer.addAllAttributes((Map)returnValue);
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

