/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.NativeWebRequest;

public class DefaultDataBinderFactory
implements WebDataBinderFactory {
    private final WebBindingInitializer bindingInitializer;

    public DefaultDataBinderFactory(WebBindingInitializer bindingInitializer) {
        this.bindingInitializer = bindingInitializer;
    }

    public WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
        WebDataBinder dataBinder = this.createBinderInstance(target, objectName);
        if (this.bindingInitializer != null) {
            this.bindingInitializer.initBinder(dataBinder, webRequest);
        }
        return dataBinder;
    }

    protected WebDataBinder createBinderInstance(Object target, String objectName) {
        return new WebRequestDataBinder(target, objectName);
    }
}

