/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.core.env.DefaultEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.jndi.JndiPropertySource;

public class DefaultWebEnvironment
extends DefaultEnvironment {
    public static final String SERVLET_CONTEXT_PROPERTY_SOURCE_NAME = "servletContextInitParams";
    public static final String SERVLET_CONFIG_PROPERTY_SOURCE_NAME = "servletConfigInitParams";

    public DefaultWebEnvironment() {
        this.getPropertySources().addFirst((PropertySource)new PropertySource.StubPropertySource(SERVLET_CONTEXT_PROPERTY_SOURCE_NAME));
        this.getPropertySources().addFirst((PropertySource)new PropertySource.StubPropertySource(SERVLET_CONFIG_PROPERTY_SOURCE_NAME));
        Boolean jndiPropertySourceEnabled = (Boolean)this.getProperty("jndiPropertySourceEnabled", Boolean.TYPE);
        if (jndiPropertySourceEnabled != null && jndiPropertySourceEnabled.booleanValue()) {
            this.getPropertySources().addAfter(SERVLET_CONTEXT_PROPERTY_SOURCE_NAME, (PropertySource)new JndiPropertySource());
        }
    }
}

