/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.InterceptingClientHttpRequest;
import org.springframework.util.Assert;

public class InterceptingClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory requestFactory;
    private final ClientHttpRequestInterceptor[] interceptors;

    public InterceptingClientHttpRequestFactory(ClientHttpRequestFactory requestFactory, ClientHttpRequestInterceptor[] interceptors) {
        Assert.notNull((Object)requestFactory, (String)"'requestFactory' must not be null");
        this.requestFactory = requestFactory;
        this.interceptors = interceptors != null ? interceptors : new ClientHttpRequestInterceptor[]{};
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new InterceptingClientHttpRequest(this.requestFactory, this.interceptors, uri, httpMethod);
    }
}

