/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.caucho.Hessian1SkeletonInvoker;
import org.springframework.remoting.caucho.Hessian2SkeletonInvoker;
import org.springframework.remoting.caucho.HessianSkeletonInvoker;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.util.NestedServletException;

public class HessianServiceExporter
extends RemoteExporter
implements HttpRequestHandler,
InitializingBean {
    private static final boolean hessian2Available = ClassUtils.isPresent((String)"com.caucho.hessian.io.Hessian2Input", (ClassLoader)HessianServiceExporter.class.getClassLoader());
    private SerializerFactory serializerFactory = new SerializerFactory();
    private HessianSkeletonInvoker skeletonInvoker;

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory != null ? serializerFactory : new SerializerFactory();
    }

    public void setSendCollectionType(boolean sendCollectionType) {
        this.serializerFactory.setSendCollectionType(sendCollectionType);
    }

    public void afterPropertiesSet() {
        this.prepare();
    }

    public void prepare() {
        HessianSkeleton skeleton = null;
        try {
            try {
                Constructor ctor = HessianSkeleton.class.getConstructor(Object.class, Class.class);
                this.checkService();
                this.checkServiceInterface();
                skeleton = (HessianSkeleton)ctor.newInstance(this.getProxyForService(), this.getServiceInterface());
            }
            catch (NoSuchMethodException ex) {
                Constructor ctor = HessianSkeleton.class.getConstructor(Object.class);
                skeleton = (HessianSkeleton)ctor.newInstance(this.getProxyForService());
            }
        }
        catch (Throwable ex) {
            throw new BeanInitializationException("Hessian skeleton initialization failed", ex);
        }
        this.skeletonInvoker = hessian2Available ? new Hessian2SkeletonInvoker(skeleton, this.serializerFactory) : new Hessian1SkeletonInvoker(skeleton, this.serializerFactory);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Assert.notNull((Object)this.skeletonInvoker, (String)"HessianServiceExporter has not been initialized");
        if (!"POST".equals(request.getMethod())) {
            throw new HttpRequestMethodNotSupportedException("POST", "HessianServiceExporter only supports POST requests");
        }
        try {
            this.skeletonInvoker.invoke((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (Throwable ex) {
            throw new NestedServletException("Hessian skeleton invocation failed", ex);
        }
    }
}

