/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;

public abstract class AbstractRequestAttributes
implements RequestAttributes {
    protected final Map requestDestructionCallbacks = new LinkedHashMap(8);
    private volatile boolean requestActive = true;

    public void requestCompleted() {
        this.executeRequestDestructionCallbacks();
        this.updateAccessedSessionAttributes();
        this.requestActive = false;
    }

    protected final boolean isRequestActive() {
        return this.requestActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerRequestDestructionCallback(String name, Runnable callback) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)callback, (String)"Callback must not be null");
        Map map = this.requestDestructionCallbacks;
        synchronized (map) {
            this.requestDestructionCallbacks.put(name, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeRequestDestructionCallback(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Map map = this.requestDestructionCallbacks;
        synchronized (map) {
            this.requestDestructionCallbacks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequestDestructionCallbacks() {
        Map map = this.requestDestructionCallbacks;
        synchronized (map) {
            Iterator it = this.requestDestructionCallbacks.values().iterator();
            while (it.hasNext()) {
                ((Runnable)it.next()).run();
            }
            this.requestDestructionCallbacks.clear();
        }
    }

    protected abstract void updateAccessedSessionAttributes();
}

