/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class HandshakeWebSocketService
implements WebSocketService,
Lifecycle {
    private static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    private static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final boolean tomcatPresent = ClassUtils.isPresent((String)"org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", (ClassLoader)HandshakeWebSocketService.class.getClassLoader());
    private static final boolean jettyPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.websocket.server.WebSocketServerFactory", (ClassLoader)HandshakeWebSocketService.class.getClassLoader());
    private static final boolean reactorNettyPresent = ClassUtils.isPresent((String)"reactor.ipc.netty.http.server.HttpServerResponse", (ClassLoader)HandshakeWebSocketService.class.getClassLoader());
    private static final boolean rxNettyPresent = ClassUtils.isPresent((String)"io.reactivex.netty.protocol.http.server.HttpServerResponse", (ClassLoader)HandshakeWebSocketService.class.getClassLoader());
    private static final boolean undertowPresent = ClassUtils.isPresent((String)"io.undertow.websockets.WebSocketProtocolHandshakeHandler", (ClassLoader)HandshakeWebSocketService.class.getClassLoader());
    protected static final Log logger = LogFactory.getLog(HandshakeWebSocketService.class);
    private final RequestUpgradeStrategy upgradeStrategy;
    private volatile boolean running = false;

    public HandshakeWebSocketService() {
        this(HandshakeWebSocketService.initUpgradeStrategy());
    }

    public HandshakeWebSocketService(RequestUpgradeStrategy upgradeStrategy) {
        Assert.notNull((Object)upgradeStrategy, (String)"'upgradeStrategy' is required");
        this.upgradeStrategy = upgradeStrategy;
    }

    private static RequestUpgradeStrategy initUpgradeStrategy() {
        String className;
        if (tomcatPresent) {
            className = "TomcatRequestUpgradeStrategy";
        } else if (jettyPresent) {
            className = "JettyRequestUpgradeStrategy";
        } else if (reactorNettyPresent) {
            className = "ReactorNettyRequestUpgradeStrategy";
        } else if (rxNettyPresent) {
            className = "RxNettyRequestUpgradeStrategy";
        } else if (undertowPresent) {
            className = "UndertowRequestUpgradeStrategy";
        } else {
            throw new IllegalStateException("No suitable default RequestUpgradeStrategy found");
        }
        try {
            className = HandshakeWebSocketService.class.getPackage().getName() + "." + className;
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)HandshakeWebSocketService.class.getClassLoader());
            return (RequestUpgradeStrategy)ReflectionUtils.accessibleConstructor((Class)clazz, (Class[])new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to instantiate RequestUpgradeStrategy: " + className, ex);
        }
    }

    public RequestUpgradeStrategy getUpgradeStrategy() {
        return this.upgradeStrategy;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            this.doStart();
        }
    }

    protected void doStart() {
        if (this.getUpgradeStrategy() instanceof Lifecycle) {
            ((Lifecycle)this.getUpgradeStrategy()).start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            this.doStop();
        }
    }

    protected void doStop() {
        if (this.getUpgradeStrategy() instanceof Lifecycle) {
            ((Lifecycle)this.getUpgradeStrategy()).stop();
        }
    }

    @Override
    public Mono<Void> handleRequest(ServerWebExchange exchange, WebSocketHandler handler) {
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = request.getMethod();
        HttpHeaders headers = request.getHeaders();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Handling " + request.getURI() + " with headers: " + headers));
        }
        if (HttpMethod.GET != method) {
            return Mono.error((Throwable)new MethodNotAllowedException(method.name(), Collections.singleton("GET")));
        }
        if (!"WebSocket".equalsIgnoreCase(headers.getUpgrade())) {
            return this.handleBadRequest("Invalid 'Upgrade' header: " + headers);
        }
        List connectionValue = headers.getConnection();
        if (!connectionValue.contains("Upgrade") && !connectionValue.contains("upgrade")) {
            return this.handleBadRequest("Invalid 'Connection' header: " + headers);
        }
        String key = headers.getFirst(SEC_WEBSOCKET_KEY);
        if (key == null) {
            return this.handleBadRequest("Missing \"Sec-WebSocket-Key\" header");
        }
        Optional<String> protocol = this.selectProtocol(headers, handler);
        return this.upgradeStrategy.upgrade(exchange, handler, protocol);
    }

    private Mono<Void> handleBadRequest(String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)reason);
        }
        return Mono.error((Throwable)new ServerWebInputException(reason));
    }

    private Optional<String> selectProtocol(HttpHeaders headers, WebSocketHandler handler) {
        String protocolHeader = headers.getFirst(SEC_WEBSOCKET_PROTOCOL);
        if (protocolHeader == null) {
            return Optional.empty();
        }
        String[] protocols = handler.getSubProtocols();
        return StringUtils.commaDelimitedListToSet((String)protocolHeader).stream().filter(protocol -> Arrays.stream(protocols).anyMatch(protocol::equals)).findFirst();
    }
}

