/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.ws.WebSocketConnection;
import io.reactivex.netty.protocol.http.ws.client.WebSocketRequest;
import io.reactivex.netty.protocol.http.ws.client.WebSocketResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.RxNettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClientSupport;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;
import rx.Observable;
import rx.RxReactiveStreams;

public class RxNettyWebSocketClient
extends WebSocketClientSupport
implements WebSocketClient {
    private final Function<URI, HttpClient<ByteBuf, ByteBuf>> httpClientProvider;

    public RxNettyWebSocketClient() {
        this(RxNettyWebSocketClient::getDefaultHttpClientProvider);
    }

    public RxNettyWebSocketClient(Function<URI, HttpClient<ByteBuf, ByteBuf>> httpClientProvider) {
        this.httpClientProvider = httpClientProvider;
    }

    private static HttpClient<ByteBuf, ByteBuf> getDefaultHttpClientProvider(URI url) {
        boolean secure = "wss".equals(url.getScheme());
        int port = url.getPort() > 0 ? url.getPort() : (secure ? 443 : 80);
        return HttpClient.newClient((String)url.getHost(), (int)port);
    }

    public Function<URI, HttpClient<ByteBuf, ByteBuf>> getHttpClientProvider() {
        return this.httpClientProvider;
    }

    public HttpClient<ByteBuf, ByteBuf> getHttpClient(URI url) {
        return this.httpClientProvider.apply(url);
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers, WebSocketHandler handler) {
        Observable<Void> completion = this.executeInternal(url, headers, handler);
        return Mono.from((Publisher)RxReactiveStreams.toPublisher(completion));
    }

    private Observable<Void> executeInternal(URI url, HttpHeaders headers, WebSocketHandler handler) {
        String[] protocols = this.beforeHandshake(url, headers, handler);
        return this.createRequest(url, headers, protocols).flatMap(response -> {
            Observable conn = response.getWebSocketConnection();
            return Observable.zip((Observable)Observable.just((Object)response), (Observable)conn, Tuples::of);
        }).flatMap(tuple -> {
            WebSocketResponse response = (WebSocketResponse)tuple.getT1();
            WebSocketConnection conn = (WebSocketConnection)tuple.getT2();
            HandshakeInfo info = this.afterHandshake(url, this.toHttpHeaders((WebSocketResponse<ByteBuf>)response));
            ByteBufAllocator allocator = response.unsafeNettyChannel().alloc();
            NettyDataBufferFactory factory = new NettyDataBufferFactory(allocator);
            RxNettyWebSocketSession session = new RxNettyWebSocketSession(conn, info, factory);
            session.aggregateFrames(response.unsafeNettyChannel(), HttpHandlerNames.WsClientDecoder.getName());
            return RxReactiveStreams.toObservable(handler.handle(session));
        });
    }

    private WebSocketRequest<ByteBuf> createRequest(URI url, HttpHeaders headers, String[] protocols) {
        String query = url.getRawQuery();
        String requestUrl = url.getRawPath() + (query != null ? "?" + query : "");
        HttpClientRequest request = this.getHttpClient(url).createGet(requestUrl);
        if (!headers.isEmpty()) {
            HashMap map = new HashMap(headers.size());
            headers.forEach((key, values) -> {
                List cfr_ignored_0 = map.put(key, new ArrayList(headers.get(key)));
            });
            request = request.setHeaders(map);
        }
        return ObjectUtils.isEmpty((Object[])protocols) ? request.requestWebSocketUpgrade() : request.requestWebSocketUpgrade().requestSubProtocols(protocols);
    }

    private HttpHeaders toHttpHeaders(WebSocketResponse<ByteBuf> response) {
        HttpHeaders headers = new HttpHeaders();
        response.headerIterator().forEachRemaining(entry -> {
            String name = ((CharSequence)entry.getKey()).toString();
            headers.put(name, response.getAllHeaderValues((CharSequence)name));
        });
        return headers;
    }
}

