/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view.freemarker;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfig;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FreeMarkerView
extends AbstractUrlBasedView {
    private Configuration configuration;
    private String encoding;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.getConfiguration() == null) {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
        }
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), FreeMarkerConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    @Override
    public boolean checkResourceExists(Locale locale) throws Exception {
        try {
            this.getTemplate(locale);
            return true;
        }
        catch (FileNotFoundException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No FreeMarker view found for URL: " + this.getUrl()));
            }
            return false;
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    @Override
    protected Mono<Void> renderInternal(Map<String, Object> renderAttributes, MediaType contentType, ServerWebExchange exchange) {
        Locale acceptLocale;
        SimpleHash freeMarkerModel = this.getTemplateModel(renderAttributes, exchange);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering FreeMarker template [" + this.getUrl() + "]."));
        }
        Locale locale = (acceptLocale = exchange.getRequest().getHeaders().getAcceptLanguageAsLocale()) != null ? acceptLocale : Locale.getDefault();
        DataBuffer dataBuffer = exchange.getResponse().bufferFactory().allocateBuffer();
        try {
            Charset charset = this.getCharset(contentType).orElse(this.getDefaultCharset());
            OutputStreamWriter writer = new OutputStreamWriter(dataBuffer.asOutputStream(), charset);
            this.getTemplate(locale).process((Object)freeMarkerModel, (Writer)writer);
        }
        catch (IOException ex) {
            String message = "Could not load FreeMarker template for URL [" + this.getUrl() + "]";
            return Mono.error((Throwable)new IllegalStateException(message, ex));
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
        return exchange.getResponse().writeWith((Publisher)Flux.just((Object)dataBuffer));
    }

    private Optional<Charset> getCharset(MediaType mediaType) {
        return mediaType != null ? Optional.ofNullable(mediaType.getCharset()) : Optional.empty();
    }

    protected SimpleHash getTemplateModel(Map<String, Object> model, ServerWebExchange exchange) {
        SimpleHash fmModel = new SimpleHash(this.getObjectWrapper());
        fmModel.putAll(model);
        return fmModel;
    }

    protected ObjectWrapper getObjectWrapper() {
        ObjectWrapper ow = this.getConfiguration().getObjectWrapper();
        Version version = Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS;
        return ow != null ? ow : new DefaultObjectWrapperBuilder(version).build();
    }

    protected Template getTemplate(Locale locale) throws IOException {
        return this.getEncoding() != null ? this.getConfiguration().getTemplate(this.getUrl(), locale, this.getEncoding()) : this.getConfiguration().getTemplate(this.getUrl(), locale);
    }
}

