/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Locale;
import java.util.function.Function;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.reactive.result.view.AbstractView;
import org.springframework.web.reactive.result.view.RedirectView;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.reactive.result.view.ViewResolverSupport;
import reactor.core.publisher.Mono;

public class UrlBasedViewResolver
extends ViewResolverSupport
implements ViewResolver,
InitializingBean {
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    private Class<?> viewClass;
    private String prefix = "";
    private String suffix = "";
    private String[] viewNames;
    private Function<String, RedirectView> redirectViewProvider = url -> new RedirectView((String)url);
    private String requestContextAttribute;

    public void setViewClass(Class<?> viewClass) {
        if (viewClass == null || !this.requiredViewClass().isAssignableFrom(viewClass)) {
            String name = viewClass != null ? viewClass.getName() : null;
            throw new IllegalArgumentException("Given view class [" + name + "] is not of type [" + this.requiredViewClass().getName() + "]");
        }
        this.viewClass = viewClass;
    }

    protected Class<?> getViewClass() {
        return this.viewClass;
    }

    protected Class<?> requiredViewClass() {
        return AbstractUrlBasedView.class;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    public void setViewNames(String ... viewNames) {
        this.viewNames = viewNames;
    }

    protected String[] getViewNames() {
        return this.viewNames;
    }

    public void setRedirectViewProvider(Function<String, RedirectView> redirectViewProvider) {
        this.redirectViewProvider = redirectViewProvider;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    protected String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getViewClass() == null) {
            throw new IllegalArgumentException("Property 'viewClass' is required");
        }
    }

    @Override
    public Mono<View> resolveViewName(String viewName, Locale locale) {
        AbstractUrlBasedView urlBasedView;
        if (!this.canHandle(viewName, locale)) {
            return Mono.empty();
        }
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            urlBasedView = this.redirectViewProvider.apply(redirectUrl);
        } else {
            urlBasedView = this.createUrlBasedView(viewName);
        }
        View view = this.applyLifecycleMethods(viewName, urlBasedView);
        try {
            return urlBasedView.checkResourceExists(locale) ? Mono.just((Object)view) : Mono.empty();
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    protected boolean canHandle(String viewName, Locale locale) {
        String[] viewNames = this.getViewNames();
        return viewNames == null || PatternMatchUtils.simpleMatch((String[])viewNames, (String)viewName);
    }

    protected AbstractUrlBasedView createUrlBasedView(String viewName) {
        AbstractUrlBasedView view = (AbstractUrlBasedView)BeanUtils.instantiateClass(this.getViewClass());
        view.setSupportedMediaTypes(this.getSupportedMediaTypes());
        view.setRequestContextAttribute(this.getRequestContextAttribute());
        view.setDefaultCharset(this.getDefaultCharset());
        view.setUrl(this.getPrefix() + viewName + this.getSuffix());
        return view;
    }

    private View applyLifecycleMethods(String viewName, AbstractView view) {
        return (View)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)view, viewName);
    }
}

