/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class ServerWebExchangeArgumentResolver
implements SyncHandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return ServerWebExchange.class.isAssignableFrom(paramType) || ServerHttpRequest.class.isAssignableFrom(paramType) || ServerHttpResponse.class.isAssignableFrom(paramType) || HttpMethod.class == paramType;
    }

    @Override
    public Optional<Object> resolveArgumentValue(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        Class paramType = parameter.getParameterType();
        if (ServerWebExchange.class.isAssignableFrom(paramType)) {
            return Optional.of(exchange);
        }
        if (ServerHttpRequest.class.isAssignableFrom(paramType)) {
            return Optional.of(exchange.getRequest());
        }
        if (ServerHttpResponse.class.isAssignableFrom(paramType)) {
            return Optional.of(exchange.getResponse());
        }
        if (HttpMethod.class == paramType) {
            return Optional.of(exchange.getRequest().getMethod());
        }
        throw new IllegalArgumentException("Unknown parameter type: " + paramType + " in method: " + parameter.getMethod());
    }
}

