/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.server.ServerWebExchange;

public class InitBinderBindingContext
extends BindingContext {
    private final List<SyncInvocableHandlerMethod> binderMethods;
    private final BindingContext bindingContext;

    public InitBinderBindingContext(WebBindingInitializer initializer, List<SyncInvocableHandlerMethod> binderMethods) {
        super(initializer);
        this.binderMethods = binderMethods;
        this.bindingContext = new BindingContext(initializer);
    }

    @Override
    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder binder, ServerWebExchange exchange) {
        this.binderMethods.stream().filter(method -> this.isBinderMethodApplicable((HandlerMethod)method, (WebDataBinder)binder)).forEach(method -> this.invokeInitBinderMethod(binder, exchange, (SyncInvocableHandlerMethod)((Object)method)));
        return binder;
    }

    protected boolean isBinderMethodApplicable(HandlerMethod binderMethod, WebDataBinder binder) {
        InitBinder annot = (InitBinder)binderMethod.getMethodAnnotation(InitBinder.class);
        List<String> names = Arrays.asList(annot.value());
        return names.size() == 0 || names.contains(binder.getObjectName());
    }

    private void invokeInitBinderMethod(WebExchangeDataBinder binder, ServerWebExchange exchange, SyncInvocableHandlerMethod method) {
        HandlerResult result = method.invokeForHandlerResult(exchange, this.bindingContext, binder);
        if (result.getReturnValue().isPresent()) {
            throw new IllegalStateException("@InitBinder methods should return void: " + (Object)((Object)method));
        }
    }
}

