/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageReaderArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HttpEntityArgumentResolver
extends AbstractMessageReaderArgumentResolver
implements HandlerMethodArgumentResolver {
    public HttpEntityArgumentResolver(List<HttpMessageReader<?>> readers) {
        super(readers);
    }

    public HttpEntityArgumentResolver(List<HttpMessageReader<?>> readers, ReactiveAdapterRegistry registry) {
        super(readers, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class clazz = parameter.getParameterType();
        return HttpEntity.class.equals((Object)clazz) || RequestEntity.class.equals((Object)clazz);
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter param, BindingContext bindingContext, ServerWebExchange exchange) {
        ResolvableType entityType = ResolvableType.forMethodParameter((MethodParameter)param);
        MethodParameter bodyParameter = new MethodParameter(param);
        bodyParameter.increaseNestingLevel();
        return this.readBody(bodyParameter, false, bindingContext, exchange).map(body -> this.createHttpEntity(body, entityType, exchange)).defaultIfEmpty(this.createHttpEntity(null, entityType, exchange));
    }

    private Object createHttpEntity(Object body, ResolvableType entityType, ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        if (RequestEntity.class == entityType.getRawClass()) {
            return new RequestEntity(body, (MultiValueMap)headers, request.getMethod(), request.getURI());
        }
        return new HttpEntity(body, (MultiValueMap)headers);
    }
}

