/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerHttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageReaderArgumentResolver {
    private final List<HttpMessageReader<?>> messageReaders;
    private final ReactiveAdapterRegistry adapterRegistry;
    private final List<MediaType> supportedMediaTypes;

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> readers) {
        this(readers, new ReactiveAdapterRegistry());
    }

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> messageReaders, ReactiveAdapterRegistry adapterRegistry) {
        Assert.notEmpty(messageReaders, (String)"At least one HttpMessageReader is required.");
        Assert.notNull((Object)adapterRegistry, (String)"'adapterRegistry' is required");
        this.messageReaders = messageReaders;
        this.adapterRegistry = adapterRegistry;
        this.supportedMediaTypes = messageReaders.stream().flatMap(converter -> converter.getReadableMediaTypes().stream()).collect(Collectors.toList());
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    protected Mono<Object> readBody(MethodParameter bodyParameter, boolean isBodyRequired, BindingContext bindingContext, ServerWebExchange exchange) {
        ResolvableType bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(bodyType.resolve());
        ResolvableType elementType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        if (adapter != null) {
            elementType = elementType.getGeneric(new int[]{0});
        }
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        MediaType mediaType = request.getHeaders().getContentType();
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        for (HttpMessageReader<?> reader : this.getMessageReaders()) {
            Object[] hints;
            Mono mono;
            if (!reader.canRead(elementType, mediaType)) continue;
            Map readHints = Collections.emptyMap();
            if (adapter != null && adapter.isMultiValue()) {
                Object[] hints2;
                Flux flux;
                if (reader instanceof ServerHttpMessageReader) {
                    ServerHttpMessageReader serverReader = (ServerHttpMessageReader)reader;
                    flux = serverReader.read(bodyType, elementType, request, response, readHints);
                } else {
                    flux = reader.read(elementType, (ReactiveHttpInputMessage)request, readHints);
                }
                flux = flux.onErrorResumeWith(ex -> Flux.error((Throwable)this.wrapReadError((Throwable)ex, bodyParameter)));
                if (this.checkRequired(adapter, isBodyRequired)) {
                    flux = flux.switchIfEmpty((Publisher)Flux.error((Throwable)this.getRequiredBodyError(bodyParameter)));
                }
                if ((hints2 = this.extractValidationHints(bodyParameter)) != null) {
                    flux = flux.doOnNext(target -> this.validate(target, hints2, bodyParameter, bindingContext, exchange));
                }
                return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
            }
            if (reader instanceof ServerHttpMessageReader) {
                ServerHttpMessageReader serverReader = (ServerHttpMessageReader)reader;
                mono = serverReader.readMono(bodyType, elementType, request, response, readHints);
            } else {
                mono = reader.readMono(elementType, (ReactiveHttpInputMessage)request, readHints);
            }
            mono = mono.otherwise(ex -> Mono.error((Throwable)this.wrapReadError((Throwable)ex, bodyParameter)));
            if (this.checkRequired(adapter, isBodyRequired)) {
                mono = mono.otherwiseIfEmpty(Mono.error((Throwable)this.getRequiredBodyError(bodyParameter)));
            }
            if ((hints = this.extractValidationHints(bodyParameter)) != null) {
                mono = mono.doOnNext(target -> this.validate(target, hints, bodyParameter, bindingContext, exchange));
            }
            if (adapter != null) {
                return Mono.just((Object)adapter.fromPublisher((Publisher)mono));
            }
            return Mono.from((Publisher)mono);
        }
        return Mono.error((Throwable)new UnsupportedMediaTypeStatusException(mediaType, this.supportedMediaTypes));
    }

    protected ServerWebInputException wrapReadError(Throwable ex, MethodParameter parameter) {
        return new ServerWebInputException("Failed to read HTTP message", parameter, ex);
    }

    protected boolean checkRequired(ReactiveAdapter adapter, boolean isBodyRequired) {
        return adapter != null && !adapter.supportsEmpty() || isBodyRequired;
    }

    protected ServerWebInputException getRequiredBodyError(MethodParameter parameter) {
        return new ServerWebInputException("Required request body is missing: " + parameter.getMethod().toGenericString());
    }

    protected Object[] extractValidationHints(MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validAnnot = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validAnnot == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validAnnot != null ? validAnnot.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            return objectArray;
        }
        return null;
    }

    protected void validate(Object target, Object[] validationHints, MethodParameter param, BindingContext binding, ServerWebExchange exchange) {
        String name = Conventions.getVariableNameForParameter((MethodParameter)param);
        WebExchangeDataBinder binder = binding.createDataBinder(exchange, target, name);
        binder.validate(validationHints);
        if (binder.getBindingResult().hasErrors()) {
            throw new WebExchangeBindException(param, binder.getBindingResult());
        }
    }
}

