/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Mono<Object[]> EMPTY_ARGS = Mono.just((Object)new Object[0]);
    private static final Object NO_ARG_VALUE = new Object();
    private List<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean, Method method) {
        super(bean, method);
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.resolvers.clear();
        this.resolvers.addAll(resolvers);
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer nameDiscoverer) {
        this.parameterNameDiscoverer = nameDiscoverer;
    }

    public Mono<HandlerResult> invoke(ServerWebExchange exchange, BindingContext bindingContext, Object ... providedArgs) {
        return this.resolveArguments(exchange, bindingContext, providedArgs).then(args -> {
            try {
                Object value = this.doInvoke((Object[])args);
                HandlerResult result = new HandlerResult((Object)this, value, this.getReturnType(), bindingContext);
                return Mono.just((Object)result);
            }
            catch (InvocationTargetException ex) {
                return Mono.error((Throwable)ex.getTargetException());
            }
            catch (Throwable ex) {
                String msg = this.getInvocationErrorMessage((Object[])args);
                return Mono.error((Throwable)new IllegalStateException(msg));
            }
        });
    }

    private Mono<Object[]> resolveArguments(ServerWebExchange exchange, BindingContext bindingContext, Object ... providedArgs) {
        if (ObjectUtils.isEmpty((Object[])this.getMethodParameters())) {
            return EMPTY_ARGS;
        }
        try {
            List argMonos = Stream.of(this.getMethodParameters()).map(param -> {
                param.initParameterNameDiscovery(this.parameterNameDiscoverer);
                GenericTypeResolver.resolveParameterType((MethodParameter)param, this.getBean().getClass());
                return this.findProvidedArg((MethodParameter)param, providedArgs).map(Mono::just).orElseGet(() -> {
                    HandlerMethodArgumentResolver resolver = this.findResolver((MethodParameter)param);
                    return this.resolveArg(resolver, (MethodParameter)param, bindingContext, exchange);
                });
            }).collect(Collectors.toList());
            return Mono.when(argMonos, argValues -> Stream.of(argValues).map(o -> o != NO_ARG_VALUE ? o : null).toArray());
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private Optional<Object> findProvidedArg(MethodParameter param, Object ... providedArgs) {
        if (ObjectUtils.isEmpty((Object[])providedArgs)) {
            return Optional.empty();
        }
        return Arrays.stream(providedArgs).filter(arg -> param.getParameterType().isInstance(arg)).findFirst();
    }

    private HandlerMethodArgumentResolver findResolver(MethodParameter param) {
        return this.resolvers.stream().filter(r -> r.supportsParameter(param)).findFirst().orElseThrow(() -> this.getArgumentError("No resolver for ", param, null));
    }

    private Mono<Object> resolveArg(HandlerMethodArgumentResolver resolver, MethodParameter param, BindingContext bindingContext, ServerWebExchange exchange) {
        try {
            return resolver.resolveArgument(param, bindingContext, exchange).defaultIfEmpty(NO_ARG_VALUE).doOnError(cause -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.getDetailedErrorMessage("Error resolving ", param), cause);
                }
            });
        }
        catch (Exception ex) {
            throw this.getArgumentError("Error resolving ", param, ex);
        }
    }

    private IllegalStateException getArgumentError(String message, MethodParameter param, Throwable ex) {
        return new IllegalStateException(this.getDetailedErrorMessage(message, param), ex);
    }

    private String getDetailedErrorMessage(String message, MethodParameter param) {
        return message + "argument [" + param.getParameterIndex() + "] of type [" + param.getParameterType().getName() + "] on method [" + this.getBridgedMethod().toGenericString() + "]";
    }

    private Object doInvoke(Object[] args) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking '" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), (Class)this.getBeanType()) + "' with arguments " + Arrays.toString(args)));
        }
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        Object returnValue = this.getBridgedMethod().invoke(this.getBean(), args);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Method [" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), (Class)this.getBeanType()) + "] returned [" + returnValue + "]"));
        }
        return returnValue;
    }

    private String getInvocationErrorMessage(Object[] args) {
        String argumentDetails = IntStream.range(0, args.length).mapToObj(i -> args[i] != null ? "[" + i + "][type=" + args[i].getClass().getName() + "][value=" + args[i] + "]" : "[" + i + "][null]").collect(Collectors.joining(",", " ", " "));
        return "Failed to invoke controller with resolved arguments:" + argumentDetails + "on method [" + this.getBridgedMethod().toGenericString() + "]";
    }
}

