/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.CompositeContentTypeResolver;
import org.springframework.web.reactive.accept.PathExtensionContentTypeResolver;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.DefaultResourceTransformerChain;
import org.springframework.web.reactive.resource.HttpResource;
import org.springframework.web.reactive.resource.PathResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class ResourceWebHandler
implements WebHandler,
InitializingBean,
SmartInitializingSingleton {
    private static final Set<String> SUPPORTED_METHODS = new LinkedHashSet<String>(2);
    private static final Log logger = LogFactory.getLog(ResourceWebHandler.class);
    private final List<Resource> locations = new ArrayList<Resource>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    private CacheControl cacheControl;
    private ResourceHttpMessageWriter resourceHttpMessageWriter;
    private CompositeContentTypeResolver contentTypeResolver;
    private PathExtensionContentTypeResolver pathExtensionResolver;

    public void setLocations(List<Resource> locations) {
        Assert.notNull(locations, (String)"Locations list must not be null");
        this.locations.clear();
        this.locations.addAll(locations);
    }

    public List<Resource> getLocations() {
        return this.locations;
    }

    public void setResourceResolvers(List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setCacheControl(CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public void setResourceHttpMessageWriter(ResourceHttpMessageWriter httpMessageWriter) {
        this.resourceHttpMessageWriter = httpMessageWriter;
    }

    public ResourceHttpMessageWriter getResourceHttpMessageWriter() {
        return this.resourceHttpMessageWriter;
    }

    public void setContentTypeResolver(CompositeContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }

    public CompositeContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isWarnEnabled() && CollectionUtils.isEmpty(this.locations)) {
            logger.warn((Object)"Locations list is empty. No resources will be served unless a custom ResourceResolver is configured as an alternative to PathResourceResolver.");
        }
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        if (this.resourceHttpMessageWriter == null) {
            this.resourceHttpMessageWriter = new ResourceHttpMessageWriter();
        }
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.locations)) {
            return;
        }
        for (int i = this.getResourceResolvers().size() - 1; i >= 0; --i) {
            if (!(this.getResourceResolvers().get(i) instanceof PathResourceResolver)) continue;
            PathResourceResolver resolver = (PathResourceResolver)this.getResourceResolvers().get(i);
            if (!ObjectUtils.isEmpty((Object[])resolver.getAllowedLocations())) break;
            resolver.setAllowedLocations(this.getLocations().toArray(new Resource[this.getLocations().size()]));
            break;
        }
    }

    public void afterSingletonsInstantiated() {
        this.pathExtensionResolver = this.initContentNegotiationStrategy();
    }

    protected PathExtensionContentTypeResolver initContentNegotiationStrategy() {
        PathExtensionContentTypeResolver strategy;
        HashMap<String, MediaType> mediaTypes = null;
        if (this.getContentTypeResolver() != null && (strategy = this.getContentTypeResolver().findResolver(PathExtensionContentTypeResolver.class)) != null) {
            mediaTypes = new HashMap<String, MediaType>(strategy.getMediaTypes());
        }
        return new PathExtensionContentTypeResolver(mediaTypes);
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        return this.getResource(exchange).otherwiseIfEmpty(Mono.defer(() -> {
            logger.trace((Object)"No matching resource found - returning 404");
            exchange.getResponse().setStatusCode(HttpStatus.NOT_FOUND);
            return Mono.empty();
        })).then(resource -> {
            try {
                MediaType mediaType;
                String value;
                if (HttpMethod.OPTIONS.equals((Object)exchange.getRequest().getMethod())) {
                    exchange.getResponse().getHeaders().add("Allow", "GET,HEAD,OPTIONS");
                    return Mono.empty();
                }
                String httpMehtod = exchange.getRequest().getMethod().name();
                if (!SUPPORTED_METHODS.contains(httpMehtod)) {
                    return Mono.error((Throwable)new MethodNotAllowedException(httpMehtod, SUPPORTED_METHODS));
                }
                if (exchange.checkNotModified(Instant.ofEpochMilli(resource.lastModified()))) {
                    logger.trace((Object)"Resource not modified - returning 304");
                    return Mono.empty();
                }
                if (this.getCacheControl() != null && (value = this.getCacheControl().getHeaderValue()) != null) {
                    exchange.getResponse().getHeaders().setCacheControl(value);
                }
                if ((mediaType = this.getMediaType(exchange, (Resource)resource)) != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Determined media type '" + mediaType + "' for " + resource));
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.trace((Object)("No media type found for " + resource + " - not sending a content-type header"));
                }
                if (HttpMethod.HEAD.equals((Object)exchange.getRequest().getMethod())) {
                    this.setHeaders(exchange, (Resource)resource, mediaType);
                    exchange.getResponse().getHeaders().set("Accept-Ranges", "bytes");
                    logger.trace((Object)"HEAD request - skipping content");
                    return Mono.empty();
                }
                this.setHeaders(exchange, (Resource)resource, mediaType);
                return this.resourceHttpMessageWriter.write((Publisher)Mono.just((Object)resource), null, ResolvableType.forClass(Resource.class), mediaType, exchange.getRequest(), exchange.getResponse(), Collections.emptyMap());
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        });
    }

    protected Mono<Resource> getResource(ServerWebExchange exchange) {
        String attributeName = HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE;
        Optional optional = exchange.getAttribute(attributeName);
        if (!optional.isPresent()) {
            return Mono.error((Throwable)new IllegalStateException("Required request attribute '" + attributeName + "' is not set"));
        }
        String path = this.processPath((String)optional.get());
        if (!StringUtils.hasText((String)path) || this.isInvalidPath(path)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring invalid resource path [" + path + "]"));
            }
            return Mono.empty();
        }
        if (path.contains("%")) {
            try {
                if (this.isInvalidPath(URLDecoder.decode(path, "UTF-8"))) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Ignoring invalid resource path with escape sequences [" + path + "]."));
                    }
                    return Mono.empty();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (UnsupportedEncodingException ex) {
                return Mono.error((Throwable)Exceptions.propagate((Throwable)ex));
            }
        }
        ResourceResolverChain resolveChain = this.createResolverChain();
        return resolveChain.resolveResource(exchange, path, this.getLocations()).then(resource -> {
            ResourceTransformerChain transformerChain = this.createTransformerChain(resolveChain);
            return transformerChain.transform(exchange, (Resource)resource);
        });
    }

    protected String processPath(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            String string = path = slash ? "/" + path.substring(i) : path.substring(i);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Path after trimming leading '/' and control characters: " + path));
            }
            return path;
        }
        return slash ? "/" : "";
    }

    protected boolean isInvalidPath(String path) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Applying \"invalid path\" checks to path: " + path));
        }
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"WEB-INF\" or \"META-INF\".");
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Path represents URL or has \"url:\" prefix.");
                }
                return true;
            }
        }
        if (path.contains("..") && (path = StringUtils.cleanPath((String)path)).contains("../")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"../\" after call to StringUtils#cleanPath.");
            }
            return true;
        }
        return false;
    }

    private ResourceResolverChain createResolverChain() {
        return new DefaultResourceResolverChain(this.getResourceResolvers());
    }

    private ResourceTransformerChain createTransformerChain(ResourceResolverChain resolverChain) {
        return new DefaultResourceTransformerChain(resolverChain, this.getResourceTransformers());
    }

    protected MediaType getMediaType(ServerWebExchange exchange, Resource resource) {
        return this.pathExtensionResolver.resolveMediaTypeForResource(resource);
    }

    protected void setHeaders(ServerWebExchange exchange, Resource resource, MediaType mediaType) throws IOException {
        HttpHeaders headers = exchange.getResponse().getHeaders();
        long length = resource.contentLength();
        headers.setContentLength(length);
        if (mediaType != null) {
            headers.setContentType(mediaType);
        }
        if (resource instanceof HttpResource) {
            HttpHeaders resourceHeaders = ((HttpResource)resource).getResponseHeaders();
            exchange.getResponse().getHeaders().putAll((Map)resourceHeaders);
        }
    }

    public String toString() {
        return "ResourceWebHandler [locations=" + this.getLocations() + ", resolvers=" + this.getResourceResolvers() + "]";
    }

    static {
        SUPPORTED_METHODS.addAll(Arrays.asList("GET", "HEAD"));
    }
}

