/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceWebHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.support.HttpRequestPathHelper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResourceUrlProvider
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private HttpRequestPathHelper urlPathHelper = new HttpRequestPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, ResourceWebHandler> handlerMap = new LinkedHashMap<String, ResourceWebHandler>();
    private boolean autodetect = true;

    public void setUrlPathHelper(HttpRequestPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public HttpRequestPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setHandlerMap(Map<String, ResourceWebHandler> handlerMap) {
        if (handlerMap != null) {
            this.handlerMap.clear();
            this.handlerMap.putAll(handlerMap);
            this.autodetect = false;
        }
    }

    public Map<String, ResourceWebHandler> getHandlerMap() {
        return this.handlerMap;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isAutodetect()) {
            this.handlerMap.clear();
            this.detectResourceHandlers(event.getApplicationContext());
            if (this.handlerMap.isEmpty() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No resource handling mappings found");
            }
            if (!this.handlerMap.isEmpty()) {
                this.autodetect = false;
            }
        }
    }

    protected void detectResourceHandlers(ApplicationContext appContext) {
        this.logger.debug((Object)"Looking for resource handler mappings");
        Map map = appContext.getBeansOfType(SimpleUrlHandlerMapping.class);
        ArrayList handlerMappings = new ArrayList(map.values());
        AnnotationAwareOrderComparator.sort(handlerMappings);
        for (SimpleUrlHandlerMapping hm : handlerMappings) {
            for (String pattern : hm.getHandlerMap().keySet()) {
                Object handler = hm.getHandlerMap().get(pattern);
                if (!(handler instanceof ResourceWebHandler)) continue;
                ResourceWebHandler resourceHandler = (ResourceWebHandler)handler;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found resource handler mapping: URL pattern=\"" + pattern + "\", locations=" + resourceHandler.getLocations() + ", resolvers=" + resourceHandler.getResourceResolvers()));
                }
                this.handlerMap.put(pattern, resourceHandler);
            }
        }
    }

    public final Mono<String> getForRequestUrl(ServerWebExchange exchange, String requestUrl) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for request URL \"" + requestUrl + "\""));
        }
        int prefixIndex = this.getLookupPathIndex(exchange);
        int suffixIndex = this.getEndPathIndex(requestUrl);
        String prefix = requestUrl.substring(0, prefixIndex);
        String suffix = requestUrl.substring(suffixIndex);
        String lookupPath = requestUrl.substring(prefixIndex, suffixIndex);
        return this.getForLookupPath(lookupPath).map(resolvedPath -> prefix + resolvedPath + suffix);
    }

    private int getLookupPathIndex(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String requestPath = request.getURI().getPath();
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(exchange);
        return requestPath.indexOf(lookupPath);
    }

    private int getEndPathIndex(String lookupPath) {
        int hashIndex;
        int suffixIndex = lookupPath.length();
        int queryIndex = lookupPath.indexOf("?");
        if (queryIndex > 0) {
            suffixIndex = queryIndex;
        }
        if ((hashIndex = lookupPath.indexOf("#")) > 0) {
            suffixIndex = Math.min(suffixIndex, hashIndex);
        }
        return suffixIndex;
    }

    public final Mono<String> getForLookupPath(String lookupPath) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for lookup path \"" + lookupPath + "\""));
        }
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern2 : this.handlerMap.keySet()) {
            if (!this.getPathMatcher().match(pattern2, lookupPath)) continue;
            matchingPatterns.add(pattern2);
        }
        if (matchingPatterns.isEmpty()) {
            return Mono.empty();
        }
        Comparator patternComparator = this.getPathMatcher().getPatternComparator(lookupPath);
        Collections.sort(matchingPatterns, patternComparator);
        return Flux.fromIterable(matchingPatterns).concatMap(pattern -> {
            String pathWithinMapping = this.getPathMatcher().extractPathWithinPattern(pattern, lookupPath);
            String pathMapping = lookupPath.substring(0, lookupPath.indexOf(pathWithinMapping));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking ResourceResolverChain for URL pattern \"" + pattern + "\""));
            }
            ResourceWebHandler handler = this.handlerMap.get(pattern);
            DefaultResourceResolverChain chain = new DefaultResourceResolverChain(handler.getResourceResolvers());
            return chain.resolveUrlPath(pathWithinMapping, handler.getLocations()).map(resolvedPath -> {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Resolved public resource URL path \"" + resolvedPath + "\""));
                }
                return pathMapping + resolvedPath;
            });
        }).next();
    }
}

