/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Map;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsProcessor;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.DefaultCorsProcessor;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.support.HttpRequestPathHelper;
import reactor.core.publisher.Mono;

public abstract class AbstractHandlerMapping
extends ApplicationObjectSupport
implements HandlerMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private HttpRequestPathHelper pathHelper = new HttpRequestPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final UrlBasedCorsConfigurationSource globalCorsConfigSource = new UrlBasedCorsConfigurationSource();
    private CorsProcessor corsProcessor = new DefaultCorsProcessor();
    private static final WebHandler REQUEST_HANDLED_HANDLER = exchange -> Mono.empty();

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public void setUrlDecode(boolean urlDecode) {
        this.pathHelper.setUrlDecode(urlDecode);
    }

    public void setPathHelper(HttpRequestPathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }

    public HttpRequestPathHelper getPathHelper() {
        return this.pathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
        this.globalCorsConfigSource.setPathMatcher(pathMatcher);
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations) {
        this.globalCorsConfigSource.setCorsConfigurations(corsConfigurations);
    }

    public Map<String, CorsConfiguration> getCorsConfigurations() {
        return this.globalCorsConfigSource.getCorsConfigurations();
    }

    public void setCorsProcessor(CorsProcessor corsProcessor) {
        Assert.notNull((Object)corsProcessor, (String)"CorsProcessor must not be null");
        this.corsProcessor = corsProcessor;
    }

    public CorsProcessor getCorsProcessor() {
        return this.corsProcessor;
    }

    @Override
    public Mono<Object> getHandler(ServerWebExchange exchange) {
        return this.getHandlerInternal(exchange).map(handler -> {
            if (CorsUtils.isCorsRequest((ServerHttpRequest)exchange.getRequest())) {
                CorsConfiguration config;
                CorsConfiguration configA = this.globalCorsConfigSource.getCorsConfiguration(exchange);
                CorsConfiguration configB = this.getCorsConfiguration(handler, exchange);
                CorsConfiguration corsConfiguration = config = configA != null ? configA.combine(configB) : configB;
                if (!this.getCorsProcessor().processRequest(config, exchange) || CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
                    return REQUEST_HANDLED_HANDLER;
                }
            }
            return handler;
        });
    }

    protected abstract Mono<?> getHandlerInternal(ServerWebExchange var1);

    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange) {
        if (handler != null && handler instanceof CorsConfigurationSource) {
            return ((CorsConfigurationSource)handler).getCorsConfiguration(exchange);
        }
        return null;
    }
}

