/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.server.DefaultServerResponseBuilder;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface ServerResponse {
    public HttpStatus statusCode();

    public HttpHeaders headers();

    public Mono<Void> writeTo(ServerWebExchange var1, HandlerStrategies var2);

    public static BodyBuilder from(ServerResponse other) {
        Assert.notNull((Object)other, (String)"'other' must not be null");
        DefaultServerResponseBuilder builder = new DefaultServerResponseBuilder(other.statusCode());
        return builder.headers(other.headers());
    }

    public static BodyBuilder status(HttpStatus status) {
        Assert.notNull((Object)status, (String)"HttpStatus must not be null");
        return new DefaultServerResponseBuilder(status);
    }

    public static BodyBuilder ok() {
        return ServerResponse.status(HttpStatus.OK);
    }

    public static BodyBuilder created(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.CREATED);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder accepted() {
        return ServerResponse.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return ServerResponse.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder badRequest() {
        return ServerResponse.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return ServerResponse.status(HttpStatus.NOT_FOUND);
    }

    public static BodyBuilder unprocessableEntity() {
        return ServerResponse.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public BodyBuilder hint(String var1, Object var2);

        public <T, P extends Publisher<T>> Mono<ServerResponse> body(P var1, Class<T> var2);

        public <T> Mono<ServerResponse> body(BodyInserter<T, ? super ServerHttpResponse> var1);

        public Mono<ServerResponse> render(String var1, Object ... var2);

        public Mono<ServerResponse> render(String var1, Map<String, ?> var2);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(HttpHeaders var1);

        public B allow(HttpMethod ... var1);

        public B allow(Set<HttpMethod> var1);

        public B eTag(String var1);

        public B lastModified(ZonedDateTime var1);

        public B location(URI var1);

        public B cacheControl(CacheControl var1);

        public B varyBy(String ... var1);

        public Mono<ServerResponse> build();

        public Mono<ServerResponse> build(Publisher<Void> var1);

        public Mono<ServerResponse> build(BiFunction<ServerWebExchange, HandlerStrategies, Mono<Void>> var1);
    }
}

