/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Map;
import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.PathResourceLookupFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.ResourceHandlerFunction;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import reactor.core.publisher.Mono;

public abstract class RouterFunctions {
    public static final String REQUEST_ATTRIBUTE = RouterFunctions.class.getName() + ".request";
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = RouterFunctions.class.getName() + ".uriTemplateVariables";
    private static final HandlerFunction<ServerResponse> NOT_FOUND_HANDLER = request -> ServerResponse.notFound().build();

    public static <T extends ServerResponse> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(handlerFunction, (String)"'handlerFunction' must not be null");
        return request -> predicate.test(request) ? Mono.just((Object)handlerFunction) : Mono.empty();
    }

    public static <T extends ServerResponse> RouterFunction<T> subroute(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(routerFunction, (String)"'routerFunction' must not be null");
        return request -> {
            if (predicate.test(request)) {
                ServerRequest subRequest = predicate.subRequest(request);
                return routerFunction.route(subRequest);
            }
            return Mono.empty();
        };
    }

    public static RouterFunction<ServerResponse> resources(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        Assert.notNull((Object)location, (String)"'location' must not be null");
        return RouterFunctions.resources(new PathResourceLookupFunction(pattern, location));
    }

    public static RouterFunction<ServerResponse> resources(Function<ServerRequest, Mono<Resource>> lookupFunction) {
        Assert.notNull(lookupFunction, (String)"'lookupFunction' must not be null");
        return request -> ((Mono)lookupFunction.apply(request)).map(ResourceHandlerFunction::new);
    }

    public static HttpWebHandlerAdapter toHttpHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHttpHandler(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HttpWebHandlerAdapter toHttpHandler(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return new HttpWebHandlerAdapter(exchange -> {
            DefaultServerRequest request = new DefaultServerRequest(exchange, strategies);
            RouterFunctions.addAttributes(exchange, request);
            return routerFunction.route(request).defaultIfEmpty(RouterFunctions.notFound()).then(handlerFunction -> handlerFunction.handle(request)).then(response -> response.writeTo(exchange, strategies));
        });
    }

    public static HandlerMapping toHandlerMapping(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHandlerMapping(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HandlerMapping toHandlerMapping(final RouterFunction<?> routerFunction, final HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return new HandlerMapping(){

            @Override
            public Mono<Object> getHandler(ServerWebExchange exchange) {
                DefaultServerRequest request = new DefaultServerRequest(exchange, strategies);
                RouterFunctions.addAttributes(exchange, request);
                return routerFunction.route(request).map(handlerFunction -> handlerFunction);
            }
        };
    }

    private static void addAttributes(ServerWebExchange exchange, ServerRequest request) {
        Map attributes = exchange.getAttributes();
        attributes.put(REQUEST_ATTRIBUTE, request);
    }

    private static <T extends ServerResponse> HandlerFunction<T> notFound() {
        return NOT_FOUND_HANDLER;
    }

    static <T extends ServerResponse> HandlerFunction<T> cast(HandlerFunction<?> handlerFunction) {
        return handlerFunction;
    }
}

