/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RequestPredicates {
    private static final PathMatcher DEFAULT_PATH_MATCHER = new AntPathMatcher();

    public static RequestPredicate all() {
        return request -> true;
    }

    public static RequestPredicate method(HttpMethod httpMethod) {
        return new HttpMethodPredicate(httpMethod);
    }

    public static RequestPredicate path(String pattern) {
        return RequestPredicates.path(pattern, DEFAULT_PATH_MATCHER);
    }

    public static RequestPredicate path(String pattern, PathMatcher pathMatcher) {
        return new PathPredicate(pattern, pathMatcher);
    }

    public static RequestPredicate headers(Predicate<ServerRequest.Headers> headersPredicate) {
        return new HeaderPredicates(headersPredicate);
    }

    public static RequestPredicate contentType(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        HashSet<MediaType> mediaTypeSet = new HashSet<MediaType>(Arrays.asList(mediaTypes));
        return RequestPredicates.headers(headers -> {
            MediaType contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
            return mediaTypeSet.stream().anyMatch(mediaType -> mediaType.includes(contentType));
        });
    }

    public static RequestPredicate accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        HashSet<MediaType> mediaTypeSet = new HashSet<MediaType>(Arrays.asList(mediaTypes));
        return RequestPredicates.headers(headers -> {
            List<MediaType> acceptedMediaTypes = headers.accept();
            MediaType.sortBySpecificityAndQuality(acceptedMediaTypes);
            return acceptedMediaTypes.stream().anyMatch(acceptedMediaType -> mediaTypeSet.stream().anyMatch(arg_0 -> ((MediaType)acceptedMediaType).isCompatibleWith(arg_0)));
        });
    }

    public static RequestPredicate GET(String pattern) {
        return RequestPredicates.method(HttpMethod.GET).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate HEAD(String pattern) {
        return RequestPredicates.method(HttpMethod.HEAD).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate POST(String pattern) {
        return RequestPredicates.method(HttpMethod.POST).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PUT(String pattern) {
        return RequestPredicates.method(HttpMethod.PUT).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PATCH(String pattern) {
        return RequestPredicates.method(HttpMethod.PATCH).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate DELETE(String pattern) {
        return RequestPredicates.method(HttpMethod.DELETE).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate OPTIONS(String pattern) {
        return RequestPredicates.method(HttpMethod.OPTIONS).and(RequestPredicates.path(pattern));
    }

    private static class SubPathServerRequestWrapper
    implements ServerRequest {
        private final ServerRequest request;
        private final String subPath;

        public SubPathServerRequestWrapper(ServerRequest request, String subPath) {
            this.request = request;
            this.subPath = subPath;
        }

        @Override
        public HttpMethod method() {
            return this.request.method();
        }

        @Override
        public URI uri() {
            return this.request.uri();
        }

        @Override
        public String path() {
            return this.subPath;
        }

        @Override
        public ServerRequest.Headers headers() {
            return this.request.headers();
        }

        @Override
        public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
            return this.request.body(extractor);
        }

        @Override
        public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor, Map<String, Object> hints) {
            return this.request.body(extractor, hints);
        }

        @Override
        public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
            return this.request.bodyToMono(elementClass);
        }

        @Override
        public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
            return this.request.bodyToFlux(elementClass);
        }

        @Override
        public <T> Optional<T> attribute(String name) {
            return this.request.attribute(name);
        }

        @Override
        public Optional<String> queryParam(String name) {
            return this.request.queryParam(name);
        }

        @Override
        public List<String> queryParams(String name) {
            return this.request.queryParams(name);
        }

        @Override
        public String pathVariable(String name) {
            return this.request.pathVariable(name);
        }

        @Override
        public Map<String, String> pathVariables() {
            return this.request.pathVariables();
        }
    }

    private static class HeaderPredicates
    implements RequestPredicate {
        private final Predicate<ServerRequest.Headers> headersPredicate;

        public HeaderPredicates(Predicate<ServerRequest.Headers> headersPredicate) {
            Assert.notNull(headersPredicate, (String)"'headersPredicate' must not be null");
            this.headersPredicate = headersPredicate;
        }

        @Override
        public boolean test(ServerRequest request) {
            return this.headersPredicate.test(request.headers());
        }
    }

    private static class PathPredicate
    implements RequestPredicate {
        private final String pattern;
        private final PathMatcher pathMatcher;

        public PathPredicate(String pattern, PathMatcher pathMatcher) {
            Assert.notNull((Object)pattern, (String)"'pattern' must not be null");
            Assert.notNull((Object)pathMatcher, (String)"'pathMatcher' must not be null");
            this.pattern = pattern;
            this.pathMatcher = pathMatcher;
        }

        @Override
        public boolean test(ServerRequest request) {
            String path = request.path();
            if (this.pathMatcher.match(this.pattern, path)) {
                if (request instanceof DefaultServerRequest) {
                    DefaultServerRequest defaultRequest = (DefaultServerRequest)request;
                    Map uriTemplateVariables = this.pathMatcher.extractUriTemplateVariables(this.pattern, path);
                    defaultRequest.exchange().getAttributes().put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriTemplateVariables);
                }
                return true;
            }
            return false;
        }

        @Override
        public ServerRequest subRequest(ServerRequest request) {
            String requestPath = request.path();
            String subPath = this.pathMatcher.extractPathWithinPattern(this.pattern, requestPath);
            return new SubPathServerRequestWrapper(request, subPath);
        }
    }

    private static class HttpMethodPredicate
    implements RequestPredicate {
        private final HttpMethod httpMethod;

        public HttpMethodPredicate(HttpMethod httpMethod) {
            Assert.notNull((Object)httpMethod, (String)"'httpMethod' must not be null");
            this.httpMethod = httpMethod;
        }

        @Override
        public boolean test(ServerRequest request) {
            return this.httpMethod == request.method();
        }
    }
}

