/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.DefaultHandlerStrategiesBuilder;
import org.springframework.web.reactive.result.view.ViewResolver;

public interface HandlerStrategies {
    public Supplier<Stream<HttpMessageReader<?>>> messageReaders();

    public Supplier<Stream<HttpMessageWriter<?>>> messageWriters();

    public Supplier<Stream<ViewResolver>> viewResolvers();

    public static HandlerStrategies withDefaults() {
        return HandlerStrategies.builder().build();
    }

    public static HandlerStrategies of(ApplicationContext applicationContext) {
        return HandlerStrategies.builder(applicationContext).build();
    }

    public static HandlerStrategies of(final Supplier<Stream<HttpMessageReader<?>>> messageReaders, final Supplier<Stream<HttpMessageWriter<?>>> messageWriters, final Supplier<Stream<ViewResolver>> viewResolvers) {
        return new HandlerStrategies(){

            @Override
            public Supplier<Stream<HttpMessageReader<?>>> messageReaders() {
                return this.checkForNull(messageReaders);
            }

            @Override
            public Supplier<Stream<HttpMessageWriter<?>>> messageWriters() {
                return this.checkForNull(messageWriters);
            }

            @Override
            public Supplier<Stream<ViewResolver>> viewResolvers() {
                return this.checkForNull(viewResolvers);
            }

            private <T> Supplier<Stream<T>> checkForNull(Supplier<Stream<T>> supplier) {
                return supplier != null ? supplier : Stream::empty;
            }
        };
    }

    public static Builder builder() {
        DefaultHandlerStrategiesBuilder builder = new DefaultHandlerStrategiesBuilder();
        builder.defaultConfiguration();
        return builder;
    }

    public static Builder builder(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        DefaultHandlerStrategiesBuilder builder = new DefaultHandlerStrategiesBuilder();
        builder.applicationContext(applicationContext);
        return builder;
    }

    public static Builder empty() {
        return new DefaultHandlerStrategiesBuilder();
    }

    public static interface Builder {
        public Builder messageReader(HttpMessageReader<?> var1);

        public Builder messageWriter(HttpMessageWriter<?> var1);

        public Builder viewResolver(ViewResolver var1);

        public HandlerStrategies build();
    }
}

