/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.Conventions;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultServerResponseBuilder
implements ServerResponse.BodyBuilder {
    private final HttpStatus statusCode;
    private final HttpHeaders headers = new HttpHeaders();
    private final Map<String, Object> hints = new HashMap<String, Object>();

    public DefaultServerResponseBuilder(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public ServerResponse.BodyBuilder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder headers(HttpHeaders headers) {
        if (headers != null) {
            this.headers.putAll((Map)headers);
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder eTag(String eTag) {
        if (eTag != null) {
            if (!eTag.startsWith("\"") && !eTag.startsWith("W/\"")) {
                eTag = "\"" + eTag;
            }
            if (!eTag.endsWith("\"")) {
                eTag = eTag + "\"";
            }
        }
        this.headers.setETag(eTag);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder hint(String key, Object value) {
        this.hints.put(key, value);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(ZonedDateTime lastModified) {
        ZonedDateTime gmt = lastModified.withZoneSameInstant(ZoneId.of("GMT"));
        String headerValue = DateTimeFormatter.RFC_1123_DATE_TIME.format(gmt);
        this.headers.set("Last-Modified", headerValue);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cacheControl(CacheControl cacheControl) {
        String ccValue = cacheControl.getHeaderValue();
        if (ccValue != null) {
            this.headers.setCacheControl(cacheControl.getHeaderValue());
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public Mono<ServerResponse> build() {
        return this.build((ServerWebExchange exchange, HandlerStrategies handlerStrategies) -> exchange.getResponse().setComplete());
    }

    @Override
    public Mono<ServerResponse> build(Publisher<Void> voidPublisher) {
        Assert.notNull(voidPublisher, (String)"'voidPublisher' must not be null");
        return this.build((ServerWebExchange exchange, HandlerStrategies handlerStrategies) -> Mono.from((Publisher)voidPublisher).then(exchange.getResponse().setComplete()));
    }

    @Override
    public Mono<ServerResponse> build(BiFunction<ServerWebExchange, HandlerStrategies, Mono<Void>> writeFunction) {
        Assert.notNull(writeFunction, (String)"'writeFunction' must not be null");
        return Mono.just((Object)new WriterFunctionServerResponse(this.statusCode, this.headers, writeFunction));
    }

    @Override
    public <T, P extends Publisher<T>> Mono<ServerResponse> body(P publisher, Class<T> elementClass) {
        return this.body(BodyInserters.fromPublisher(publisher, elementClass));
    }

    @Override
    public <T> Mono<ServerResponse> body(BodyInserter<T, ? super ServerHttpResponse> inserter) {
        Assert.notNull(inserter, (String)"'inserter' must not be null");
        return Mono.just(new BodyInserterServerResponse<T>(this.statusCode, this.headers, inserter, this.hints));
    }

    @Override
    public Mono<ServerResponse> render(String name, Object ... modelAttributes) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        return this.render(name, this.toModelMap(modelAttributes));
    }

    @Override
    public Mono<ServerResponse> render(String name, Map<String, ?> model) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        LinkedHashMap<String, Object> modelMap = new LinkedHashMap<String, Object>();
        if (model != null) {
            modelMap.putAll(model);
        }
        return Mono.just((Object)new RenderingServerResponse(this.statusCode, this.headers, name, modelMap));
    }

    private Map<String, Object> toModelMap(Object[] modelAttributes) {
        if (ObjectUtils.isEmpty((Object[])modelAttributes)) {
            return null;
        }
        return Arrays.stream(modelAttributes).filter(val -> !ObjectUtils.isEmpty((Object)val)).collect(Collectors.toMap(Conventions::getVariableName, val -> val));
    }

    private static final class RenderingServerResponse
    extends AbstractServerResponse {
        private final String name;
        private final Map<String, Object> model;

        public RenderingServerResponse(HttpStatus statusCode, HttpHeaders headers, String name, Map<String, Object> model) {
            super(statusCode, headers);
            this.name = name;
            this.model = Collections.unmodifiableMap(model);
        }

        @Override
        public Mono<Void> writeTo(ServerWebExchange exchange, HandlerStrategies strategies) {
            ServerHttpResponse response = exchange.getResponse();
            this.writeStatusAndHeaders(response);
            MediaType contentType = exchange.getResponse().getHeaders().getContentType();
            Locale acceptLocale = exchange.getRequest().getHeaders().getAcceptLanguageAsLocale();
            Locale locale = acceptLocale != null ? acceptLocale : Locale.getDefault();
            Stream<ViewResolver> viewResolverStream = strategies.viewResolvers().get();
            return Flux.fromStream(viewResolverStream).concatMap(viewResolver -> viewResolver.resolveViewName(this.name, locale)).next().otherwiseIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Could not resolve view with name '" + this.name + "'"))).then(view -> view.render(this.model, contentType, exchange));
        }
    }

    private static final class BodyInserterServerResponse<T>
    extends AbstractServerResponse {
        private final BodyInserter<T, ? super ServerHttpResponse> inserter;
        private final Map<String, Object> hints;

        public BodyInserterServerResponse(HttpStatus statusCode, HttpHeaders headers, BodyInserter<T, ? super ServerHttpResponse> inserter, Map<String, Object> hints) {
            super(statusCode, headers);
            this.inserter = inserter;
            this.hints = hints;
        }

        @Override
        public Mono<Void> writeTo(ServerWebExchange exchange, final HandlerStrategies strategies) {
            ServerHttpResponse response = exchange.getResponse();
            this.writeStatusAndHeaders(response);
            return this.inserter.insert((ServerHttpResponse)response, new BodyInserter.Context(){

                @Override
                public Supplier<Stream<HttpMessageWriter<?>>> messageWriters() {
                    return strategies.messageWriters();
                }

                @Override
                public Map<String, Object> hints() {
                    return hints;
                }
            });
        }
    }

    private static final class WriterFunctionServerResponse
    extends AbstractServerResponse {
        private final BiFunction<ServerWebExchange, HandlerStrategies, Mono<Void>> writeFunction;

        public WriterFunctionServerResponse(HttpStatus statusCode, HttpHeaders headers, BiFunction<ServerWebExchange, HandlerStrategies, Mono<Void>> writeFunction) {
            super(statusCode, headers);
            this.writeFunction = writeFunction;
        }

        @Override
        public Mono<Void> writeTo(ServerWebExchange exchange, HandlerStrategies strategies) {
            this.writeStatusAndHeaders(exchange.getResponse());
            return this.writeFunction.apply(exchange, strategies);
        }
    }

    private static abstract class AbstractServerResponse
    implements ServerResponse {
        private final HttpStatus statusCode;
        private final HttpHeaders headers;

        protected AbstractServerResponse(HttpStatus statusCode, HttpHeaders headers) {
            this.statusCode = statusCode;
            this.headers = AbstractServerResponse.readOnlyCopy(headers);
        }

        private static HttpHeaders readOnlyCopy(HttpHeaders headers) {
            HttpHeaders copy = new HttpHeaders();
            copy.putAll((Map)headers);
            return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)copy);
        }

        @Override
        public final HttpStatus statusCode() {
            return this.statusCode;
        }

        @Override
        public final HttpHeaders headers() {
            return this.headers;
        }

        protected void writeStatusAndHeaders(ServerHttpResponse response) {
            response.setStatusCode(this.statusCode);
            HttpHeaders responseHeaders = response.getHeaders();
            if (!this.headers.isEmpty()) {
                this.headers.entrySet().stream().filter(entry -> !responseHeaders.containsKey(entry.getKey())).forEach(entry -> responseHeaders.put((String)entry.getKey(), (List)entry.getValue()));
            }
        }
    }
}

