/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.function.Function;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ExchangeFilterFunction {
    public Mono<ClientResponse> filter(ClientRequest<?> var1, ExchangeFunction var2);

    default public ExchangeFilterFunction andThen(ExchangeFilterFunction after) {
        Assert.notNull((Object)after, (String)"'after' must not be null");
        return (request, next) -> {
            ExchangeFunction nextExchange = exchangeRequest -> after.filter(exchangeRequest, next);
            return this.filter(request, nextExchange);
        };
    }

    default public ExchangeFunction apply(ExchangeFunction exchange) {
        Assert.notNull((Object)exchange, (String)"'exchange' must not be null");
        return request -> this.filter(request, exchange);
    }

    public static ExchangeFilterFunction ofRequestProcessor(Function<ClientRequest<?>, Mono<ClientRequest<?>>> requestProcessor) {
        Assert.notNull(requestProcessor, (String)"'requestProcessor' must not be null");
        return (request, next) -> ((Mono)requestProcessor.apply(request)).then(next::exchange);
    }

    public static ExchangeFilterFunction ofResponseProcessor(Function<ClientResponse, Mono<ClientResponse>> responseProcessor) {
        Assert.notNull(responseProcessor, (String)"'responseProcessor' must not be null");
        return (request, next) -> next.exchange(request).then(responseProcessor);
    }
}

