/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.UnsupportedMediaTypeException;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyExtractor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BodyExtractors {
    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(Class<? extends T> elementClass) {
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyExtractors.toMono(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(ResolvableType elementType) {
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        return (request, context) -> BodyExtractors.readWithMessageReaders(request, context, elementType, reader -> reader.readMono(elementType, request, context.hints()), Mono::error);
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(Class<? extends T> elementClass) {
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyExtractors.toFlux(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(ResolvableType elementType) {
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        return (inputMessage, context) -> BodyExtractors.readWithMessageReaders(inputMessage, context, elementType, reader -> reader.read(elementType, inputMessage, context.hints()), Flux::error);
    }

    public static BodyExtractor<Flux<DataBuffer>, ReactiveHttpInputMessage> toDataBuffers() {
        return (inputMessage, context) -> inputMessage.getBody();
    }

    private static <T, S extends Publisher<T>> S readWithMessageReaders(ReactiveHttpInputMessage inputMessage, BodyExtractor.Context context, ResolvableType elementType, Function<HttpMessageReader<T>, S> readerFunction, Function<Throwable, S> unsupportedError) {
        MediaType contentType = BodyExtractors.contentType((HttpMessage)inputMessage);
        Supplier<Stream<HttpMessageReader<?>>> messageReaders = context.messageReaders();
        return (S)messageReaders.get().filter(r -> r.canRead(elementType, contentType)).findFirst().map(BodyExtractors::cast).map(readerFunction).orElseGet(() -> {
            List supportedMediaTypes = ((Stream)messageReaders.get()).flatMap(reader -> reader.getReadableMediaTypes().stream()).collect(Collectors.toList());
            UnsupportedMediaTypeException error = new UnsupportedMediaTypeException(contentType, supportedMediaTypes);
            return (Publisher)unsupportedError.apply((Throwable)error);
        });
    }

    private static MediaType contentType(HttpMessage message) {
        MediaType result = message.getHeaders().getContentType();
        return result != null ? result : MediaType.APPLICATION_OCTET_STREAM;
    }

    private static <T> HttpMessageReader<T> cast(HttpMessageReader<?> messageReader) {
        return messageReader;
    }
}

