/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.MediaType;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.AbstractHandlerResultHandler;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.HttpRequestPathHelper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ViewResolutionResultHandler
extends AbstractHandlerResultHandler
implements HandlerResultHandler,
Ordered {
    private static final Object NO_VALUE = new Object();
    private static final Mono<Object> NO_VALUE_MONO = Mono.just((Object)NO_VALUE);
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(4);
    private final List<View> defaultViews = new ArrayList<View>(4);
    private final HttpRequestPathHelper pathHelper = new HttpRequestPathHelper();

    public ViewResolutionResultHandler(List<ViewResolver> resolvers, RequestedContentTypeResolver contentTypeResolver) {
        this(resolvers, contentTypeResolver, new ReactiveAdapterRegistry());
    }

    public ViewResolutionResultHandler(List<ViewResolver> resolvers, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        this.viewResolvers.addAll(resolvers);
        AnnotationAwareOrderComparator.sort(this.viewResolvers);
    }

    public List<ViewResolver> getViewResolvers() {
        return Collections.unmodifiableList(this.viewResolvers);
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews.clear();
        if (defaultViews != null) {
            this.defaultViews.addAll(defaultViews);
        }
    }

    public List<View> getDefaultViews() {
        return this.defaultViews;
    }

    @Override
    public boolean supports(HandlerResult result) {
        Class clazz = result.getReturnType().getRawClass();
        if (this.hasModelAttributeAnnotation(result)) {
            return true;
        }
        Optional<Object> optional = result.getReturnValue();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(clazz, optional);
        if (adapter != null) {
            if (adapter.getDescriptor().isNoValue()) {
                return true;
            }
            clazz = result.getReturnType().getGeneric(new int[]{0}).getRawClass();
            return this.isSupportedType(clazz);
        }
        return this.isSupportedType(clazz);
    }

    private boolean hasModelAttributeAnnotation(HandlerResult result) {
        MethodParameter returnType = result.getReturnTypeSource();
        return returnType.hasMethodAnnotation(ModelAttribute.class);
    }

    private boolean isSupportedType(Class<?> clazz) {
        return CharSequence.class.isAssignableFrom(clazz) || View.class.isAssignableFrom(clazz) || Model.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || !BeanUtils.isSimpleProperty(clazz);
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        ResolvableType elementType;
        Mono returnValueMono;
        ResolvableType parameterType = result.getReturnType();
        Optional<Object> optional = result.getReturnValue();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(parameterType.getRawClass(), optional);
        if (adapter != null) {
            returnValueMono = optional.map(value -> adapter.toMono(value).cast(Object.class)).orElse(Mono.empty());
            elementType = !adapter.getDescriptor().isNoValue() ? parameterType.getGeneric(new int[]{0}) : ResolvableType.forClass(Void.class);
        } else {
            returnValueMono = Mono.justOrEmpty(result.getReturnValue());
            elementType = parameterType;
        }
        return returnValueMono.otherwiseIfEmpty(exchange.isNotModified() ? Mono.empty() : NO_VALUE_MONO).then(returnValue -> {
            Mono<List<View>> viewsMono;
            this.updateResponseStatus(result.getReturnTypeSource(), exchange);
            Model model = result.getModel();
            Locale locale = Locale.getDefault();
            Class<?> clazz = elementType.getRawClass();
            if (clazz == null) {
                clazz = returnValue.getClass();
            }
            if (returnValue == NO_VALUE || Void.class.equals(clazz) || Void.TYPE.equals(clazz)) {
                viewsMono = this.resolveViews(this.getDefaultViewName(result, exchange), locale);
            } else if (Model.class.isAssignableFrom(clazz)) {
                model.addAllAttributes(((Model)returnValue).asMap());
                viewsMono = this.resolveViews(this.getDefaultViewName(result, exchange), locale);
            } else if (Map.class.isAssignableFrom(clazz)) {
                model.addAllAttributes((Map)returnValue);
                viewsMono = this.resolveViews(this.getDefaultViewName(result, exchange), locale);
            } else if (View.class.isAssignableFrom(clazz)) {
                viewsMono = Mono.just(Collections.singletonList((View)returnValue));
            } else if (CharSequence.class.isAssignableFrom(clazz) && !this.hasModelAttributeAnnotation(result)) {
                viewsMono = this.resolveViews(returnValue.toString(), locale);
            } else {
                String name = this.getNameForReturnValue(clazz, result.getReturnTypeSource());
                model.addAttribute(name, returnValue);
                viewsMono = this.resolveViews(this.getDefaultViewName(result, exchange), locale);
            }
            return this.resolveAsyncAttributes(model.asMap()).doOnSuccess(aVoid -> this.addBindingResult(result, exchange)).then(viewsMono).then(views -> this.render((List<View>)views, model.asMap(), exchange));
        });
    }

    protected String getDefaultViewName(HandlerResult result, ServerWebExchange exchange) {
        String path = this.pathHelper.getLookupPathForRequest(exchange);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return StringUtils.stripFilenameExtension((String)path);
    }

    private Mono<List<View>> resolveViews(String viewName, Locale locale) {
        return Flux.fromIterable(this.getViewResolvers()).concatMap(resolver -> resolver.resolveViewName(viewName, locale)).collectList().map(views -> {
            if (views.isEmpty()) {
                throw new IllegalStateException("Could not resolve view with name '" + viewName + "'.");
            }
            views.addAll(this.getDefaultViews());
            return views;
        });
    }

    private String getNameForReturnValue(Class<?> returnValueType, MethodParameter returnType) {
        ModelAttribute annotation = (ModelAttribute)returnType.getMethodAnnotation(ModelAttribute.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value())) {
            return annotation.value();
        }
        return ClassUtils.getShortNameAsProperty(returnValueType);
    }

    private Mono<Void> resolveAsyncAttributes(Map<String, Object> model) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Mono> valueMonos = new ArrayList<Mono>();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(null, entry.getValue());
            if (adapter == null) continue;
            names.add(entry.getKey());
            valueMonos.add(adapter.toMono(entry.getValue()).defaultIfEmpty(NO_VALUE));
        }
        if (names.isEmpty()) {
            return Mono.empty();
        }
        return Mono.when(valueMonos, values -> {
            for (int i = 0; i < ((Object[])values).length; ++i) {
                if (values[i] != NO_VALUE) {
                    model.put((String)names.get(i), values[i]);
                    continue;
                }
                model.remove(names.get(i));
            }
            return NO_VALUE;
        }).then();
    }

    private void addBindingResult(HandlerResult result, ServerWebExchange exchange) {
        BindingContext context = result.getBindingContext();
        Map model = context.getModel().asMap();
        model.keySet().stream().filter(name -> this.isBindingCandidate((String)name, model.get(name))).filter(name -> !model.containsKey(BindingResult.MODEL_KEY_PREFIX + name)).forEach(name -> {
            WebExchangeDataBinder binder = context.createDataBinder(exchange, model.get(name), (String)name);
            model.put(BindingResult.MODEL_KEY_PREFIX + name, binder.getBindingResult());
        });
    }

    private boolean isBindingCandidate(String name, Object value) {
        return !name.startsWith(BindingResult.MODEL_KEY_PREFIX) && value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }

    private Mono<? extends Void> render(List<View> views, Map<String, Object> model, ServerWebExchange exchange) {
        List<MediaType> mediaTypes = this.getMediaTypes(views);
        MediaType bestMediaType = this.selectMediaType(exchange, () -> mediaTypes);
        if (bestMediaType != null) {
            for (View view : views) {
                for (MediaType mediaType : view.getSupportedMediaTypes()) {
                    if (!mediaType.isCompatibleWith(bestMediaType)) continue;
                    return view.render(model, mediaType, exchange);
                }
            }
        }
        throw new NotAcceptableStatusException(mediaTypes);
    }

    private List<MediaType> getMediaTypes(List<View> views) {
        return views.stream().flatMap(view -> view.getSupportedMediaTypes().stream()).collect(Collectors.toList());
    }
}

