/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class RequestHeaderMapMethodArgumentResolver
implements SyncHandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestHeader.class) && Map.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public Optional<Object> resolveArgumentValue(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        Object value = this.isMultiValueMap(parameter) ? headers : headers.toSingleValueMap();
        return Optional.of(value);
    }

    private boolean isMultiValueMap(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return MultiValueMap.class.isAssignableFrom(paramType);
    }
}

