/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class ModelAttributeMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ReactiveAdapterRegistry adapterRegistry;
    private final boolean useDefaultResolution;

    public ModelAttributeMethodArgumentResolver(ReactiveAdapterRegistry registry) {
        this(registry, false);
    }

    public ModelAttributeMethodArgumentResolver(ReactiveAdapterRegistry registry, boolean useDefaultResolution) {
        Assert.notNull((Object)registry, (String)"'ReactiveAdapterRegistry' is required.");
        this.useDefaultResolution = useDefaultResolution;
        this.adapterRegistry = registry;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            return true;
        }
        if (this.useDefaultResolution) {
            Class clazz = parameter.getParameterType();
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(clazz);
            if (adapter != null) {
                ReactiveAdapter.Descriptor descriptor = adapter.getDescriptor();
                if (descriptor.isNoValue() || descriptor.isMultiValue()) {
                    return false;
                }
                clazz = ResolvableType.forMethodParameter((MethodParameter)parameter).getGeneric(new int[]{0}).getRawClass();
            }
            return !BeanUtils.isSimpleProperty((Class)clazz);
        }
        return false;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
        ReactiveAdapter adapterTo = this.getAdapterRegistry().getAdapterTo(type.resolve());
        Class valueType = adapterTo != null ? type.resolveGeneric(new int[]{0}) : parameter.getParameterType();
        String name = this.getAttributeName(valueType, parameter);
        Mono<?> valueMono = this.getAttributeMono(name, valueType, parameter, context, exchange);
        Map model = context.getModel().asMap();
        MonoProcessor bindingResultMono = MonoProcessor.create();
        model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResultMono);
        return valueMono.then(value -> {
            WebExchangeDataBinder binder = context.createDataBinder(exchange, value, name);
            return binder.bind(exchange).doOnError(arg_0 -> ((MonoProcessor)bindingResultMono).onError(arg_0)).doOnSuccess(aVoid -> {
                this.validateIfApplicable(binder, parameter);
                BindingResult errors = binder.getBindingResult();
                model.put(BindingResult.MODEL_KEY_PREFIX + name, errors);
                model.put(name, value);
                bindingResultMono.onNext((Object)errors);
            }).then(Mono.fromCallable(() -> {
                BindingResult errors = binder.getBindingResult();
                if (adapterTo != null) {
                    return adapterTo.fromPublisher((Publisher)(errors.hasErrors() ? Mono.error((Throwable)new WebExchangeBindException(parameter, errors)) : Mono.just((Object)value)));
                }
                if (errors.hasErrors() && this.checkErrorsArgument(parameter)) {
                    throw new WebExchangeBindException(parameter, errors);
                }
                return value;
            }));
        });
    }

    private String getAttributeName(Class<?> valueType, MethodParameter parameter) {
        ModelAttribute annot = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        if (annot != null && StringUtils.hasText((String)annot.value())) {
            return annot.value();
        }
        return ClassUtils.getShortNameAsProperty(valueType);
    }

    private Mono<?> getAttributeMono(String attributeName, Class<?> attributeType, MethodParameter param, BindingContext context, ServerWebExchange exchange) {
        ReactiveAdapter adapterFrom;
        Object attribute = context.getModel().asMap().get(attributeName);
        if (attribute == null) {
            attribute = this.createAttribute(attributeName, attributeType, param, context, exchange);
        }
        if (attribute != null && (adapterFrom = this.getAdapterRegistry().getAdapterFrom(null, attribute)) != null) {
            return adapterFrom.toMono(attribute);
        }
        return Mono.justOrEmpty(attribute);
    }

    protected Object createAttribute(String attributeName, Class<?> attributeType, MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        return BeanUtils.instantiateClass(attributeType);
    }

    protected boolean checkErrorsArgument(MethodParameter methodParam) {
        int i = methodParam.getParameterIndex();
        Class<?>[] paramTypes = methodParam.getMethod().getParameterTypes();
        return paramTypes.length <= i + 1 || !Errors.class.isAssignableFrom(paramTypes[i + 1]);
    }

    protected void validateIfApplicable(WebExchangeDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validAnnot = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validAnnot == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validAnnot != null ? validAnnot.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] hintArray = objectArray;
            binder.validate(new Object[]{hintArray});
        }
    }
}

