/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class ExpressionValueMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public ExpressionValueMethodArgumentResolver(ConfigurableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Value.class);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        Value annotation = (Value)parameter.getParameterAnnotation(Value.class);
        return new ExpressionValueNamedValueInfo(annotation);
    }

    @Override
    protected Optional<Object> resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        return Optional.empty();
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new UnsupportedOperationException("@Value is never required: " + parameter.getMethod());
    }

    private static class ExpressionValueNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        private ExpressionValueNamedValueInfo(Value annotation) {
            super("@Value", false, annotation.value());
        }
    }
}

