/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.ui.Model;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public abstract class AbstractNamedValueArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ConfigurableBeanFactory configurableBeanFactory;
    private final BeanExpressionContext expressionContext;
    private final Map<MethodParameter, NamedValueInfo> namedValueInfoCache = new ConcurrentHashMap<MethodParameter, NamedValueInfo>(256);

    public AbstractNamedValueArgumentResolver(ConfigurableBeanFactory beanFactory) {
        this.configurableBeanFactory = beanFactory;
        this.expressionContext = beanFactory != null ? new BeanExpressionContext(beanFactory, null) : null;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        NamedValueInfo namedValueInfo = this.getNamedValueInfo(parameter);
        MethodParameter nestedParameter = parameter.nestedIfOptional();
        Object resolvedName = this.resolveStringValue(namedValueInfo.name);
        if (resolvedName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Specified name must not resolve to null: [" + namedValueInfo.name + "]"));
        }
        Model model = bindingContext.getModel();
        return this.resolveName(resolvedName.toString(), nestedParameter, exchange).map(arg -> {
            if ("".equals(arg) && namedValueInfo.defaultValue != null) {
                arg = this.resolveStringValue(namedValueInfo.defaultValue);
            }
            arg = this.applyConversion(arg, namedValueInfo, parameter, bindingContext, exchange);
            this.handleResolvedValue(arg, namedValueInfo.name, parameter, model, exchange);
            return arg;
        }).otherwiseIfEmpty(this.getDefaultValue(namedValueInfo, parameter, bindingContext, model, exchange));
    }

    private NamedValueInfo getNamedValueInfo(MethodParameter parameter) {
        NamedValueInfo namedValueInfo = this.namedValueInfoCache.get(parameter);
        if (namedValueInfo == null) {
            namedValueInfo = this.createNamedValueInfo(parameter);
            namedValueInfo = this.updateNamedValueInfo(parameter, namedValueInfo);
            this.namedValueInfoCache.put(parameter, namedValueInfo);
        }
        return namedValueInfo;
    }

    protected abstract NamedValueInfo createNamedValueInfo(MethodParameter var1);

    private NamedValueInfo updateNamedValueInfo(MethodParameter parameter, NamedValueInfo info) {
        String name = info.name;
        if (info.name.length() == 0 && (name = parameter.getParameterName()) == null) {
            String type = parameter.getNestedParameterType().getName();
            throw new IllegalArgumentException("Name for argument type [" + type + "] not available, and parameter name information not found in class file either.");
        }
        String defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(info.defaultValue) ? null : info.defaultValue;
        return new NamedValueInfo(name, info.required, defaultValue);
    }

    private Object resolveStringValue(String value) {
        if (this.configurableBeanFactory == null) {
            return value;
        }
        String placeholdersResolved = this.configurableBeanFactory.resolveEmbeddedValue(value);
        BeanExpressionResolver exprResolver = this.configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return value;
        }
        return exprResolver.evaluate(placeholdersResolved, this.expressionContext);
    }

    protected abstract Mono<Object> resolveName(String var1, MethodParameter var2, ServerWebExchange var3);

    private Object applyConversion(Object value, NamedValueInfo namedValueInfo, MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        WebExchangeDataBinder binder = bindingContext.createDataBinder(exchange, namedValueInfo.name);
        try {
            value = binder.convertIfNecessary(value, parameter.getParameterType(), parameter);
        }
        catch (ConversionNotSupportedException ex) {
            throw new ServerErrorException("Conversion not supported.", parameter, (Throwable)ex);
        }
        catch (TypeMismatchException ex) {
            throw new ServerWebInputException("Type mismatch.", parameter, (Throwable)ex);
        }
        return value;
    }

    private Mono<Object> getDefaultValue(NamedValueInfo namedValueInfo, MethodParameter parameter, BindingContext bindingContext, Model model, ServerWebExchange exchange) {
        Object value = null;
        try {
            if (namedValueInfo.defaultValue != null) {
                value = this.resolveStringValue(namedValueInfo.defaultValue);
            } else if (namedValueInfo.required && !parameter.isOptional()) {
                this.handleMissingValue(namedValueInfo.name, parameter, exchange);
            }
            value = this.handleNullValue(namedValueInfo.name, value, parameter.getNestedParameterType());
            value = this.applyConversion(value, namedValueInfo, parameter, bindingContext, exchange);
            this.handleResolvedValue(value, namedValueInfo.name, parameter, model, exchange);
            return Mono.justOrEmpty((Object)value);
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
    }

    protected void handleMissingValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        this.handleMissingValue(name, parameter);
    }

    protected void handleMissingValue(String name, MethodParameter parameter) {
        String typeName = parameter.getNestedParameterType().getSimpleName();
        throw new ServerWebInputException("Missing argument '" + name + "' for method parameter of type " + typeName, parameter);
    }

    private Object handleNullValue(String name, Object value, Class<?> paramType) {
        if (value == null) {
            if (Boolean.TYPE.equals(paramType)) {
                return Boolean.FALSE;
            }
            if (paramType.isPrimitive()) {
                throw new IllegalStateException("Optional " + paramType.getSimpleName() + " parameter '" + name + "' is present but cannot be translated into a null value due to being declared as a primitive type. Consider declaring it as object wrapper for the corresponding primitive type.");
            }
        }
        return value;
    }

    protected void handleResolvedValue(Object arg, String name, MethodParameter parameter, Model model, ServerWebExchange exchange) {
    }

    protected static class NamedValueInfo {
        private final String name;
        private final boolean required;
        private final String defaultValue;

        public NamedValueInfo(String name, boolean required, String defaultValue) {
            this.name = name;
            this.required = required;
            this.defaultValue = defaultValue;
        }
    }
}

