/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerHttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.AbstractHandlerResultHandler;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageWriterResultHandler
extends AbstractHandlerResultHandler {
    private final List<HttpMessageWriter<?>> messageWriters;

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        super(contentTypeResolver);
        Assert.notEmpty(messageWriters, (String)"At least one message writer is required.");
        this.messageWriters = messageWriters;
    }

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        Assert.notEmpty(messageWriters, (String)"At least one message writer is required.");
        this.messageWriters = messageWriters;
    }

    public List<HttpMessageWriter<?>> getMessageWriters() {
        return this.messageWriters;
    }

    protected Mono<Void> writeBody(Object body, MethodParameter bodyParameter, ServerWebExchange exchange) {
        ResolvableType elementType;
        Mono publisher;
        ResolvableType valueType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        Class valueClass = valueType.resolve();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(valueClass, body);
        if (adapter != null) {
            publisher = adapter.toPublisher(body);
            elementType = adapter.getDescriptor().isNoValue() ? ResolvableType.forClass(Void.class) : valueType.getGeneric(new int[]{0});
        } else {
            publisher = Mono.justOrEmpty((Object)body);
            ResolvableType resolvableType = elementType = valueClass == null && body != null ? ResolvableType.forInstance((Object)body) : valueType;
        }
        if (Void.TYPE == elementType.getRawClass() || Void.class == elementType.getRawClass()) {
            return Mono.from((Publisher)publisher).doOnSubscribe(sub -> this.updateResponseStatus(bodyParameter, exchange));
        }
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        MediaType bestMediaType = this.selectMediaType(exchange, () -> this.getProducibleMediaTypes(elementType));
        if (bestMediaType != null) {
            for (HttpMessageWriter<?> messageWriter : this.getMessageWriters()) {
                if (!messageWriter.canWrite(elementType, bestMediaType)) continue;
                Mono bodyWriter = messageWriter instanceof ServerHttpMessageWriter ? ((ServerHttpMessageWriter)messageWriter).write((Publisher)publisher, valueType, elementType, bestMediaType, request, response, Collections.emptyMap()) : messageWriter.write((Publisher)publisher, elementType, bestMediaType, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
                return bodyWriter.doOnSubscribe(sub -> this.updateResponseStatus(bodyParameter, exchange));
            }
        } else if (this.getProducibleMediaTypes(elementType).isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("No converter for return value type: " + elementType));
        }
        return Mono.error((Throwable)new NotAcceptableStatusException(this.getProducibleMediaTypes(elementType)));
    }

    private List<MediaType> getProducibleMediaTypes(ResolvableType elementType) {
        return this.getMessageWriters().stream().filter(converter -> converter.canWrite(elementType, null)).flatMap(converter -> converter.getWritableMediaTypes().stream()).collect(Collectors.toList());
    }
}

