/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.ResourceTransformerSupport;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CssLinkResourceTransformer
extends ResourceTransformerSupport {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log logger = LogFactory.getLog(CssLinkResourceTransformer.class);
    private final List<LinkParser> linkParsers = new ArrayList<LinkParser>(2);

    public CssLinkResourceTransformer() {
        this.linkParsers.add(new ImportLinkParser());
        this.linkParsers.add(new UrlFunctionLinkParser());
    }

    @Override
    public Mono<Resource> transform(ServerWebExchange exchange, Resource resource, ResourceTransformerChain transformerChain) {
        return transformerChain.transform(exchange, resource).then(newResource -> {
            String filename = newResource.getFilename();
            if (!"css".equals(StringUtils.getFilenameExtension((String)filename))) {
                return Mono.just((Object)newResource);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Transforming resource: " + newResource));
            }
            byte[] bytes = new byte[]{};
            try {
                bytes = FileCopyUtils.copyToByteArray((InputStream)newResource.getInputStream());
            }
            catch (IOException ex) {
                return Mono.error((Throwable)Exceptions.propagate((Throwable)ex));
            }
            String fullContent = new String(bytes, DEFAULT_CHARSET);
            List<Segment> segments = this.parseContent(fullContent);
            if (segments.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"No links found.");
                }
                return Mono.just((Object)newResource);
            }
            return Flux.fromIterable(segments).concatMap(segment -> {
                String segmentContent = segment.getContent(fullContent);
                if (segment.isLink() && !this.hasScheme(segmentContent)) {
                    String link = this.toAbsolutePath(segmentContent, exchange.getRequest());
                    return this.resolveUrlPath(link, exchange, (Resource)newResource, transformerChain).defaultIfEmpty((Object)segmentContent);
                }
                return Mono.just((Object)segmentContent);
            }).reduce((Object)new StringWriter(), (writer, chunk) -> {
                writer.write((String)chunk);
                return writer;
            }).then(writer -> {
                byte[] newContent = writer.toString().getBytes(DEFAULT_CHARSET);
                return Mono.just((Object)((Object)new TransformedResource(resource, newContent)));
            });
        });
    }

    private List<Segment> parseContent(String fullContent) {
        ArrayList<Segment> links = new ArrayList<Segment>();
        for (LinkParser parser : this.linkParsers) {
            links.addAll(parser.parseLinks(fullContent));
        }
        if (links.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(links);
        int index = 0;
        ArrayList<Segment> allSegments = new ArrayList<Segment>(links);
        for (Segment link : links) {
            allSegments.add(new Segment(index, link.getStart(), false));
            index = link.getEnd();
        }
        if (index < fullContent.length()) {
            allSegments.add(new Segment(index, fullContent.length(), false));
        }
        Collections.sort(allSegments);
        return allSegments;
    }

    private boolean hasScheme(String link) {
        int schemeIndex = link.indexOf(":");
        return schemeIndex > 0 && !link.substring(0, schemeIndex).contains("/") || link.indexOf("//") == 0;
    }

    private static class Segment
    implements Comparable<Segment> {
        private final int start;
        private final int end;
        private final boolean link;

        public Segment(int start, int end, boolean isLink) {
            this.start = start;
            this.end = end;
            this.link = isLink;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean isLink() {
            return this.link;
        }

        public String getContent(String fullContent) {
            return fullContent.substring(this.start, this.end);
        }

        @Override
        public int compareTo(Segment other) {
            return this.start < other.start ? -1 : (this.start == other.start ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof Segment) {
                Segment other = (Segment)obj;
                return this.start == other.start && this.end == other.end;
            }
            return false;
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }
    }

    private static class UrlFunctionLinkParser
    extends AbstractLinkParser {
        private UrlFunctionLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "url(";
        }

        @Override
        protected int extractLink(int index, String content, Set<Segment> linksToAdd) {
            return this.addLink(index - 1, ")", content, linksToAdd);
        }
    }

    private static class ImportLinkParser
    extends AbstractLinkParser {
        private ImportLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "@import";
        }

        @Override
        protected int extractLink(int index, String content, Set<Segment> linksToAdd) {
            if (!content.substring(index, index + 4).equals("url(") && logger.isErrorEnabled()) {
                logger.error((Object)("Unexpected syntax for @import link at index " + index));
            }
            return index;
        }
    }

    protected static abstract class AbstractLinkParser
    implements LinkParser {
        protected AbstractLinkParser() {
        }

        protected abstract String getKeyword();

        @Override
        public Set<Segment> parseLinks(String fullContent) {
            HashSet<Segment> linksToAdd = new HashSet<Segment>(8);
            int index = 0;
            while ((index = fullContent.indexOf(this.getKeyword(), index)) != -1) {
                if (fullContent.charAt(index = this.skipWhitespace(fullContent, index + this.getKeyword().length())) == '\'') {
                    index = this.addLink(index, "'", fullContent, linksToAdd);
                    continue;
                }
                if (fullContent.charAt(index) == '\"') {
                    index = this.addLink(index, "\"", fullContent, linksToAdd);
                    continue;
                }
                index = this.extractLink(index, fullContent, linksToAdd);
            }
            return linksToAdd;
        }

        private int skipWhitespace(String content, int index) {
            while (Character.isWhitespace(content.charAt(index))) {
                ++index;
            }
            return index;
        }

        protected int addLink(int index, String endKey, String content, Set<Segment> linksToAdd) {
            int start = index + 1;
            int end = content.indexOf(endKey, start);
            linksToAdd.add(new Segment(start, end, true));
            return end + endKey.length();
        }

        protected abstract int extractLink(int var1, String var2, Set<Segment> var3);
    }

    @FunctionalInterface
    protected static interface LinkParser {
        public Set<Segment> parseLinks(String var1);
    }
}

