/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Scanner;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.Resource;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.ResourceTransformerSupport;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class AppCacheManifestTransformer
extends ResourceTransformerSupport {
    private static final Collection<String> MANIFEST_SECTION_HEADERS = Arrays.asList("CACHE MANIFEST", "NETWORK:", "FALLBACK:", "CACHE:");
    private static final String MANIFEST_HEADER = "CACHE MANIFEST";
    private static final String CACHE_HEADER = "CACHE:";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log logger = LogFactory.getLog(AppCacheManifestTransformer.class);
    private final String fileExtension;

    public AppCacheManifestTransformer() {
        this("appcache");
    }

    public AppCacheManifestTransformer(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    public Mono<Resource> transform(ServerWebExchange exchange, Resource inputResource, ResourceTransformerChain chain) {
        return chain.transform(exchange, inputResource).then(resource -> {
            String name = resource.getFilename();
            if (!this.fileExtension.equals(StringUtils.getFilenameExtension((String)name))) {
                return Mono.just((Object)resource);
            }
            String content = new String(AppCacheManifestTransformer.getResourceBytes(resource), DEFAULT_CHARSET);
            if (!content.startsWith(MANIFEST_HEADER)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Manifest should start with 'CACHE MANIFEST', skip: " + resource));
                }
                return Mono.just((Object)resource);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Transforming resource: " + resource));
            }
            return Flux.generate((Consumer)new LineGenerator(content)).concatMap(info -> this.processLine((LineInfo)info, exchange, (Resource)resource, chain)).collect(() -> new LineAggregator((Resource)resource, content), LineAggregator::add).then(aggregator -> Mono.just((Object)((Object)aggregator.createResource())));
        });
    }

    private static byte[] getResourceBytes(Resource resource) {
        try {
            return FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
        }
        catch (IOException ex) {
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private Mono<LineOutput> processLine(LineInfo info, ServerWebExchange exchange, Resource resource, ResourceTransformerChain chain) {
        if (!info.isLink()) {
            return Mono.just((Object)new LineOutput(info.getLine(), null));
        }
        String link = this.toAbsolutePath(info.getLine(), exchange.getRequest());
        Mono pathMono = this.resolveUrlPath(link, exchange, resource, chain).doOnNext(path -> {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Link modified: " + path + " (original: " + info.getLine() + ")"));
            }
        });
        Mono<Resource> resourceMono = chain.getResolverChain().resolveResource(null, info.getLine(), Collections.singletonList(resource));
        return Flux.zip((Publisher)pathMono, resourceMono, LineOutput::new).next();
    }

    private static class LineAggregator {
        private final StringWriter writer = new StringWriter();
        private final ByteArrayOutputStream baos;
        private final Resource resource;

        public LineAggregator(Resource resource, String content) {
            this.resource = resource;
            this.baos = new ByteArrayOutputStream(content.length());
        }

        public void add(LineOutput lineOutput) {
            this.writer.write(lineOutput.getLine() + "\n");
            try {
                byte[] bytes = lineOutput.getResource() != null ? DigestUtils.md5Digest((byte[])AppCacheManifestTransformer.getResourceBytes(lineOutput.getResource())) : lineOutput.getLine().getBytes(DEFAULT_CHARSET);
                this.baos.write(bytes);
            }
            catch (IOException ex) {
                throw Exceptions.propagate((Throwable)ex);
            }
        }

        public TransformedResource createResource() {
            String hash = DigestUtils.md5DigestAsHex((byte[])this.baos.toByteArray());
            this.writer.write("\n# Hash: " + hash);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("AppCache file: [" + this.resource.getFilename() + "] hash: [" + hash + "]"));
            }
            byte[] bytes = this.writer.toString().getBytes(DEFAULT_CHARSET);
            return new TransformedResource(this.resource, bytes);
        }
    }

    private static class LineOutput {
        private final String line;
        private final Resource resource;

        public LineOutput(String line, Resource resource) {
            this.line = line;
            this.resource = resource;
        }

        public String getLine() {
            return this.line;
        }

        public Resource getResource() {
            return this.resource;
        }
    }

    private static class LineInfo {
        private final String line;
        private final boolean cacheSection;
        private final boolean link;

        public LineInfo(String line, LineInfo previousLine) {
            this.line = line;
            this.cacheSection = LineInfo.initCacheSectionFlag(line, previousLine);
            this.link = LineInfo.iniLinkFlag(line, this.cacheSection);
        }

        private static boolean initCacheSectionFlag(String line, LineInfo previousLine) {
            if (MANIFEST_SECTION_HEADERS.contains(line.trim())) {
                return line.trim().equals(AppCacheManifestTransformer.CACHE_HEADER);
            }
            if (previousLine != null) {
                return previousLine.isCacheSection();
            }
            throw new IllegalStateException("Manifest does not start with CACHE MANIFEST: " + line);
        }

        private static boolean iniLinkFlag(String line, boolean isCacheSection) {
            return isCacheSection && StringUtils.hasText((String)line) && !line.startsWith("#") && !line.startsWith("//") && !LineInfo.hasScheme(line);
        }

        private static boolean hasScheme(String line) {
            int index = line.indexOf(":");
            return line.startsWith("//") || index > 0 && !line.substring(0, index).contains("/");
        }

        public String getLine() {
            return this.line;
        }

        public boolean isCacheSection() {
            return this.cacheSection;
        }

        public boolean isLink() {
            return this.link;
        }
    }

    private static class LineGenerator
    implements Consumer<SynchronousSink<LineInfo>> {
        private final Scanner scanner;
        private LineInfo previous;

        public LineGenerator(String content) {
            this.scanner = new Scanner(content);
        }

        @Override
        public void accept(SynchronousSink<LineInfo> sink) {
            if (this.scanner.hasNext()) {
                String line = this.scanner.nextLine();
                LineInfo current = new LineInfo(line, this.previous);
                sink.next((Object)current);
                this.previous = current;
            } else {
                sink.complete();
            }
        }
    }
}

